package com.liquidnet.service.goblin.dto.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import lombok.Data;

@Data
@HeadRowHeight(value = 20)//设置表头行高
@ColumnWidth(value = 15)//设置表头行宽
public class ActivityExcelVo {

    /**
     * 活动标题
     */
    @ExcelProperty(value = "活动标题", index = 0)
    private String title;

    @ExcelProperty(value = "时间", index = 1)
    private String excelTime;


    /**
     * 总数量
     */
    @ExcelProperty(value = "兑换码数量", index = 2)
    private Integer countNumber;

    /**
     * 使用数量
     */
    @ExcelProperty(value = "已兑换", index = 3)
    private Integer useNumber;

    /**
     * 未使用数量
     */
    @ExcelProperty(value = "未兑换", index = 4)
    private Integer unUseNumber;

    private  final  static ActivityExcelVo obj = new ActivityExcelVo();

    public static ActivityExcelVo getNew(){
        try {
            return  (ActivityExcelVo) obj.clone();
        }catch (CloneNotSupportedException e){
            return new ActivityExcelVo();
        }
    }

}
