package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

@Data
@EqualsAndHashCode
public class GoblinMixManageListVo implements Serializable, Cloneable {
    @ApiModelProperty(position = 0, value = "活动id")
    private String mixId;
    @ApiModelProperty(position = 1, value = "活动名称")
    private String name;
    @ApiModelProperty(position = 2, value = "状态[6-活动中|7-停用|9-等待开始|10-活动结束]")
    private Integer status;
    @ApiModelProperty(position = 3, value = "活动开始时间")
    private String timeStart;
    @ApiModelProperty(position = 4, value = "活动结束时间")
    private String timeEnd;
    @ApiModelProperty(position = 5, value = "活动创建时间")
    private String createdAt;
    @ApiModelProperty(position = 6, value = "剩余库存")
    private Integer restStock;

    private static final GoblinMixManageListVo obj = new GoblinMixManageListVo();

    public static GoblinMixManageListVo getNew() {
        try {
            return (GoblinMixManageListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinMixManageListVo();
        }
    }
}
