package com.liquidnet.service.goblin.param;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Api
@Data
public class CouponCountParam implements Serializable, Cloneable {
    @ApiModelProperty(dataType = "String", name = "storeCouponIds", value = "券ID数组",example = "1",required = true)
    @NotNull @NotBlank
    private List<String> storeCouponIds;
    @ApiModelProperty(dataType = "String", name = "uid", value = "用户id",example = "10",required = true)
    @NotNull @NotBlank
    private String uid;

    private static final CouponCountParam obj = new CouponCountParam();

    public static CouponCountParam getNew() {
        try {
            return (CouponCountParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new CouponCountParam();
    }
}
