package com.liquidnet.service.goblin.service.manage;

import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtCertificationParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtCompleteParam;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo;

public interface IGoblinStoreMgtCertificationService {
    /**
     * 店铺认证:认证资料保存
     *
     * @param param       GoblinStoreMgtCertificationParam
     * @param storeInfoVo GoblinStoreInfoVo
     * @return GoblinStoreInfoVo
     */
    GoblinStoreInfoVo certificationInformationProcessing(GoblinStoreMgtCertificationParam param, GoblinStoreInfoVo storeInfoVo);

    /**
     * 店铺认证:完善信息保存
     *
     * @param param       GoblinStoreMgtCompleteParam
     * @param storeInfoVo GoblinStoreInfoVo
     * @return boolean
     */
    boolean certificationCompleteProcessing(GoblinStoreMgtCompleteParam param, GoblinStoreInfoVo storeInfoVo);

    /**
     * 店铺认证:删除店铺处理
     *
     * @param storeId 店铺ID
     * @param uid     UID
     * @return boolean
     */
    boolean certificationCancelProcessing(String storeId, String uid);
}
