package com.liquidnet.service.sweet.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetManualSort;
import com.liquidnet.service.sweet.service.ISweetManualSortService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 电子宣传手册显示内容表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-23
 */
@Api(tags = "电子手册显示tag")
@RestController
@RequestMapping("/sweet-manual-sort")
public class SweetManualSortController {

    @Autowired
    private ISweetManualSortService sweetManualSortService;


    @GetMapping("add")
    @ApiOperation("操作 电子手册tag")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "content", value = "内容 例子(POSITION_1,POSITION_2)", required = true)
    })
    public ResponseDto<Boolean> changeStatus(@RequestParam(defaultValue = "1") String manualId,
                                             @RequestParam(defaultValue = "") String content) {
        return sweetManualSortService.add(manualId, content);
    }

    @GetMapping("get")
    @ApiOperation("获取 电子手册tag")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true)
    })
    public ResponseDto<SweetManualSort> changeStatus(@RequestParam(defaultValue = "1") String manualId) {
        return sweetManualSortService.get(manualId);
    }
}
