package com.liquidnet.service.consumer.kylin.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.kylin.receiver.ConsumerGoblinXlsRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.time.Duration;

@Configuration
public class ConsumerGoblinXlsRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerGoblinXlsRdsReceiver consumerGoblinXlsRdsReceiver;

    /**
     * 缺票登记
     *
     * @param listenerContainer
     * @param t
     * @return
     */
    private Subscription receiveGoblinXls(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(Consumer.from(MQConst.GoblinQueue.GOBLIN_XLS_OPERA.getGroup(), getConsumerName(MQConst.GoblinQueue.GOBLIN_XLS_OPERA.name() + t)),
                StreamOffset.create(MQConst.GoblinQueue.GOBLIN_XLS_OPERA.getKey(), ReadOffset.lastConsumed()), consumerGoblinXlsRdsReceiver);
    }

    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */

    /* -------------------------------------------------------- ｜ 缺票登记 */

    @Bean
    public Subscription subscriptionGoblinXls0(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveGoblinXls(listenerContainer, 0);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionGoblinXls1(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveGoblinXls(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionGoblinXls2(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveGoblinXls(listenerContainer, 2);
        listenerContainer.start();
        return subscription;
    }

    /* -------------------------------------------------------- ｜  */
}
