package com.liquidnet.service.consumer.kylin.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.consumer.kylin.receiver.ConsumerKylinSqlOrderOvertimeRefundRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.time.Duration;

import static com.liquidnet.service.base.constant.MQConst.KylinQueue.SQL_ORDER_OVERTIME_REFUND;

@Configuration
public class ConsumerKylinSqlOrderOvertimeRefundRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerKylinSqlOrderOvertimeRefundRdsReceiver consumerKylinSqlOrderOvertimeRefundRdsReceiver;

    /**
     * 超时支付申请退款
     *
     * @param listenerContainer
     * @param t
     * @return
     */
    private Subscription receiveSqlOrderOvertimeRefund(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(Consumer.from(SQL_ORDER_OVERTIME_REFUND.getGroup(), getConsumerName(SQL_ORDER_OVERTIME_REFUND.name() + t)),
                StreamOffset.create(SQL_ORDER_OVERTIME_REFUND.getKey(), ReadOffset.lastConsumed()), consumerKylinSqlOrderOvertimeRefundRdsReceiver);
    }

    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */

    /* -------------------------------------------------------- ｜ 超时支付申请退款 */

    @Bean
    public Subscription subscriptionSqlOrderOvertimeRefund0(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlOrderOvertimeRefund(listenerContainer, 0);
        listenerContainer.start();
        return subscription;
    }

    /* -------------------------------------------------------- ｜  */
}
