/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.endpoint.protocol;

import com.taobao.api.internal.toplink.endpoint.Message;
import com.taobao.api.internal.toplink.endpoint.MessageIO;
import com.taobao.api.internal.toplink.endpoint.protocol.CompatibleUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.HashMap;

public class MessageDecoder01
implements MessageIO.MessageDecoder {
    public Message readMessage(ByteBuffer buffer) {
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        Message msg = new Message();
        msg.protocolVersion = 1;
        msg.messageType = buffer.get();
        HashMap<String, Object> dict = new HashMap<String, Object>();
        short headerType = buffer.getShort();
        while (headerType != 0) {
            if (headerType == 1) {
                dict.put(MessageDecoder01.readCountedString(buffer), MessageDecoder01.readCustomValue(buffer));
            } else if (headerType == 2) {
                msg.statusCode = buffer.getInt();
            } else if (headerType == 3) {
                msg.statusPhase = MessageDecoder01.readCountedString(buffer);
            } else if (headerType == 4) {
                msg.flag = buffer.getInt();
            } else if (headerType == 5) {
                msg.token = MessageDecoder01.readCountedString(buffer);
            }
            headerType = buffer.getShort();
        }
        msg.content = dict;
        buffer.order(ByteOrder.BIG_ENDIAN);
        return msg;
    }

    private static String readCountedString(ByteBuffer buffer) {
        int size = buffer.getInt();
        if (size > 0) {
            byte[] data = new byte[size];
            buffer.get(data, 0, data.length);
            return CompatibleUtil.newString(data, "UTF-8");
        }
        return null;
    }

    private static Object readCustomValue(ByteBuffer buffer) {
        byte format = buffer.get();
        switch (format) {
            case 0: {
                return null;
            }
            case 2: {
                return buffer.get();
            }
            case 3: {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                short value = buffer.getShort();
                buffer.order(ByteOrder.BIG_ENDIAN);
                return value;
            }
            case 4: {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                int intValue = buffer.getInt();
                buffer.order(ByteOrder.BIG_ENDIAN);
                return intValue;
            }
            case 5: {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                long longValue = buffer.getLong();
                buffer.order(ByteOrder.BIG_ENDIAN);
                return longValue;
            }
            case 6: {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                long ticks = buffer.getLong();
                buffer.order(ByteOrder.BIG_ENDIAN);
                return new Date(ticks);
            }
        }
        return MessageDecoder01.readCountedString(buffer);
    }
}

