package com.liquidnet.service.reconciliation.strategy.accounting.impl;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.api.sequence.feign.FeignSequenceClient;
import com.liquidnet.service.reconciliation.constant.ReconConstants;
import com.liquidnet.service.reconciliation.constant.ReconConstants.BankChannelEnum;
import com.liquidnet.service.reconciliation.dto.FundFlowCommonInfo;
import com.liquidnet.service.reconciliation.dto.TdFundflowUploadVO;
import com.liquidnet.service.reconciliation.dto.TransFundQueryFilter;
import com.liquidnet.service.reconciliation.entity.LrAccountCheckBatch;
import com.liquidnet.service.reconciliation.entity.LrAccountCheckBatchSub;
import com.liquidnet.service.reconciliation.strategy.accounting.annotation.StrategyComparingAccountHandler;
import com.liquidnet.service.reconciliation.strategy.funddata.GetFundDataStrategyContext;
import com.liquidnet.service.reconciliation.strategy.transtype.TransTypeStrategyContext;
import com.liquidnet.service.reconciliation.vo.ReconciliationEntityVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: TODO
 * @class: ComparingAccountLiquidnetWallet
 * @Package com.liquidnet.service.reconciliation.accounting
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/23 16:05
 */
@Component
@StrategyComparingAccountHandler(ReconConstants.BankChannelEnum.CURRENCY_CLOUD)
public class ComparingAccountStrategyCurrencyCloudImpl extends AbstractComparingAccountStrategy {
    @Autowired
    private FeignSequenceClient feignSequenceClient;

    @Override
    public void setBankChannel(ReconConstants.BankChannelEnum bankChannel) {

    }

    @Override
    public void setInfoBankChannel(ReconConstants.BankChannelEnum infoBankChannel) {

    }

    @Override
    protected Map<String, LrAccountCheckBatchSub> getBatchSubMap(LrAccountCheckBatch batch) {
        Map<String, LrAccountCheckBatchSub> batchSubMap = new HashMap<>();
        LrAccountCheckBatchSub lrAccountCheckBatchSub = new LrAccountCheckBatchSub();
        lrAccountCheckBatchSub.setBatchNo(batch.getBatchNo());
        lrAccountCheckBatchSub.setTransType(ReconConstants.TransTypeEnum.RECHARGE.getCode());
        lrAccountCheckBatchSub.setTradeCount(BigDecimal.ZERO);
        lrAccountCheckBatchSub.setBankTradeCount(BigDecimal.ZERO);
        lrAccountCheckBatchSub.setTradeAmount(BigDecimal.ZERO);
        lrAccountCheckBatchSub.setBankTradeAmount(BigDecimal.ZERO);
        lrAccountCheckBatchSub.setMistakeCount(BigDecimal.ZERO);
        lrAccountCheckBatchSub.setUnhandleMistakeCount(BigDecimal.ZERO);
        lrAccountCheckBatchSub.setCreateTime(DateUtil.asLocalDateTime(new Date()));

        lrAccountCheckBatchSub.setId(feignSequenceClient.nextId().toString());
        batchSubMap.put(ReconConstants.TransTypeEnum.RECHARGE.getCode(),lrAccountCheckBatchSub);

        LrAccountCheckBatchSub  lrAccountCheckBatchSub2 = new LrAccountCheckBatchSub();
        BeanUtils.copyProperties(lrAccountCheckBatchSub,lrAccountCheckBatchSub2);
        lrAccountCheckBatchSub2.setId(feignSequenceClient.nextId().toString());
        batchSubMap.put(ReconConstants.TransTypeEnum.PAYOUT.getCode(),lrAccountCheckBatchSub2);

        LrAccountCheckBatchSub  lrAccountCheckBatchSub3 = new LrAccountCheckBatchSub();
        BeanUtils.copyProperties(lrAccountCheckBatchSub,lrAccountCheckBatchSub3);
        lrAccountCheckBatchSub3.setId(feignSequenceClient.nextId().toString());
        batchSubMap.put(ReconConstants.TransTypeEnum.EXCHANGE.getCode(),lrAccountCheckBatchSub3);
        return null;
    }
}
