/**
 * $Id$
 * Copyright(C) 2015-2020 kowlone - internet center, All Rights Reserved.
 */
package com.liquidnet.commons.lang;

import com.liquidnet.commons.lang.keywords.IKeywordsFilter;
import com.liquidnet.commons.lang.keywords.KeywordsACFilter;

/**
 * @author <a href="kowlone2006@163.com">kowlone</a>
 * @version 1.0 2015年09月14日 15:33:00
 */
public class Package {

	private static final char[] IGNORE_CHARS = { '　', ' ', '*', '-' };
	public static final char SUBSTITUTE_CHAR = '*';


	public static void main(String[] args) {
		IKeywordsFilter filter = new KeywordsACFilter(IGNORE_CHARS, 'f');
		String[] dirtyWords = {"测试关键词"};
		filter.initialize(dirtyWords);
		System.out.println(filter.filter("测试关键词,发生尽快了解了"));
		String string = "测试关键词,发生尽快了解了";

		System.out.println(replace(string,"测试关键词","http://www.baidu.com"));

	}


	private static String replace(String input,String keyword,String link){
		return input.replaceAll(keyword,"<a href='"+link+"'>"+keyword+"</a>");
	}

}
