package com.liquidnet.service.goblin.param;

import com.liquidnet.service.goblin.dto.manage.AddressVo;
import com.liquidnet.service.goblin.dto.manage.GoblinOrderStoreParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

@ApiModel(value = "GoblinNtfOrderPayParam", description = "下单所需参数")
@Data
public class GoblinNtfOrderPayParam {

    @ApiModelProperty(value = "openId")
    private String openId;

    @ApiModelProperty(value = "用户id")
    private String uid;

    @ApiModelProperty(value = "扫码枪code")
    private String authCode;

    @ApiModelProperty(value = "支付类型")
    @NotNull(message = "支付类型不能为空")
    private String payType;

    @ApiModelProperty(value = "支付来源 [新增micropay-微信扫码支付]")
    @NotNull(message = "支付来源不能为空")
    private String deviceFrom;

    @ApiModelProperty(value = "代理id")
    private String agentId;

    @ApiModelProperty(value = "收货地址id[虚拟物品不需要]")
    private ArrayList<String> addressIds;

    @ApiModelProperty(value = "入场人地址vo")
    private AddressVo addressesVo;

    @ApiModelProperty(value = "showUrl")
    private String showUrl;

    @ApiModelProperty(value = "returnUrl")
    private String returnUrl;

    @ApiModelProperty(value = "商品相关参数集合")
    private List<GoblinOrderStoreParam> goblinOrderStoreParamList;

}
