package com.liquidnet.service.goblin.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@ApiModel(value = "GoblinNtfOrderPayCallbackParam", description = "支付成功回调所需参数")
@Data
public class GoblinNtfOrderPayCallbackParam implements Cloneable {

    @ApiModelProperty(value = "支付状态[1-成功|0-失败]")
    private Integer status;

    @ApiModelProperty(value = "订单ID")
    private String orderId;

    @ApiModelProperty(value = "masterOrderCode")
    private String orderCode;

    @ApiModelProperty(value = "不用管")
    private String orderCodeId;

    @ApiModelProperty(value = "[写死]HUIFU_PAY_CODE")
    private String code;

    @ApiModelProperty(value = "不用管")
    private BigDecimal price;

    @ApiModelProperty(value = "不用管")
    private String type;

    @ApiModelProperty(value = "汇付相关id")
    private String paymentId;

    @ApiModelProperty(value = "[写死]huifu")
    private String paymentType;

    @ApiModelProperty(value = "支付时间")
    private String paymentAt;

    private static final GoblinNtfOrderPayCallbackParam obj = new GoblinNtfOrderPayCallbackParam();

    public static GoblinNtfOrderPayCallbackParam getNew() {
        try {
            return (GoblinNtfOrderPayCallbackParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNtfOrderPayCallbackParam();
        }
    }
}
