package com.liquidnet.service.goblin.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfMarketingVo;
import com.liquidnet.service.goblin.dto.vo.GoblinShowStoreInfoVo;
import com.liquidnet.service.goblin.service.IGoblinAppZhengzaiService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@Slf4j
@Api(tags = "正在下单相关")
@RestController
@RequestMapping("/zhengzai")
public class GoblinAppZhengzaiController {

    @Autowired
    IGoblinAppZhengzaiService goblinAppZhengzaiService;

    @GetMapping("market/list")
    @ApiOperation("正在下单-活动列表")
    public ResponseDto<List<GoblinSelfMarketingVo>> getZhengzaiMarketList() {
        return ResponseDto.success(goblinAppZhengzaiService.getZhengzaiMarketList());
    }

    @GetMapping("store/list")
    @ApiOperation("正在下单-参与活动的店铺")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
    })
    public ResponseDto<List<GoblinShowStoreInfoVo>> getStoreList(@RequestParam("marketId") @Valid String marketId) {
        return ResponseDto.success(goblinAppZhengzaiService.getStoreList(marketId));
    }
}
