package com.liquidnet.service.goblin.util;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.dto.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
public class GoblinRedisUtils {
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    GoblinMongoUtils goblinMongoUtils;


    /* ---------------------------------------- sku库存相关 ---------------------------------------- */
    public void setSkuStock(String marketPre, String skuId, Integer stock) {
        String rk = GoblinRedisConst.REAL_STOCK_SKU;
        if (marketPre != null) {
            rk = rk.concat(marketPre + ":");
        }
        rk = rk.concat(skuId);
        redisUtil.set(rk, stock);
    }

    public int getSkuStock(String marketPre, String skuId) {
        String rk = GoblinRedisConst.REAL_STOCK_SKU;
        if (marketPre != null) {
            rk = rk.concat(marketPre + ":");
        }
        rk = rk.concat(skuId);
        Object obj = redisUtil.get(rk);
        if (obj == null) {
            return 0;
        } else {
            return (int) obj;
        }
    }

    public int incrSkuStock(String marketPre, String skuId, Integer stock) {
        String rk = GoblinRedisConst.REAL_STOCK_SKU;
        if (marketPre != null) {
            rk = rk.concat(marketPre + ":");
        }
        rk = rk.concat(skuId);
        return (int) redisUtil.incr(rk, stock);
    }

    public int decrSkuStock(String marketPre, String skuId, Integer stock) {
        String rk = GoblinRedisConst.REAL_STOCK_SKU;
        if (marketPre != null) {
            rk = rk.concat(marketPre + ":");
        }
        rk = rk.concat(skuId);
        return (int) redisUtil.decr(rk, stock);
    }

    /* ---------------------------------------- 店铺数据源 ---------------------------------------- */

    private boolean setStoreIdByUid(String uid, String storeId) {
        return redisUtil.set(GoblinRedisConst.TMP_UID_STORE.concat(uid), storeId);
    }

    public void delStoreIdByUid(String uid) {
        redisUtil.del(GoblinRedisConst.TMP_UID_STORE.concat(uid));
    }

    private String getStoreIdByUid(String uid) {
        return (String) redisUtil.get(GoblinRedisConst.TMP_UID_STORE.concat(uid));
    }

    public boolean setStoreInfoVo(GoblinStoreInfoVo vo) {
        this.setStoreIdByUid(vo.getUid(), vo.getStoreId());
        return redisUtil.set(GoblinRedisConst.BASIC_STORE.concat(vo.getStoreId()), vo);
    }

    public void delStoreInfoVo(String storeId) {
        redisUtil.del(GoblinRedisConst.BASIC_STORE.concat(storeId));
    }

    public GoblinStoreInfoVo getStoreInfoVo(String storeId) {
        String rk = GoblinRedisConst.BASIC_STORE.concat(storeId);
        GoblinStoreInfoVo vo = (GoblinStoreInfoVo) redisUtil.get(rk);
        if (null == vo && null != (vo = goblinMongoUtils.getStoreInfoVo(storeId))) {
//            redisUtil.set(rk, vo);// TODO: 2022/1/4 zhanggb:暂不设置
        }
        return vo;
    }

    public GoblinStoreInfoVo getStoreInfoVoByUid(String uid) {
        String storeId = this.getStoreIdByUid(uid);
        return null == storeId ? goblinMongoUtils.getStoreInfoVoByUid(uid) : this.getStoreInfoVo(storeId);
    }

    /* ---------------------------------------- 商品数据源 ---------------------------------------- */

    public boolean setGoodsInfoVo(GoblinGoodsInfoVo vo) {
        return redisUtil.set(GoblinRedisConst.BASIC_GOODS.concat(vo.getSpuId()), vo);
    }

    public void delGoodsInfoVo(String spuId) {
        redisUtil.del(GoblinRedisConst.BASIC_GOODS.concat(spuId));
    }

    /**
     * 商品基础信息
     *
     * @param spuId 商品ID
     * @return GoblinGoodsInfoVo
     */
    public GoblinGoodsInfoVo getGoodsInfoVo(String spuId) {
        String rk = GoblinRedisConst.BASIC_GOODS.concat(spuId);
        GoblinGoodsInfoVo vo = (GoblinGoodsInfoVo) redisUtil.get(rk);
        if (null == vo && null != (vo = goblinMongoUtils.getGoodsInfoVo(spuId))) {
//            redisUtil.set(rk, vo);// TODO: 2022/1/4 zhanggb:暂不设置
        }
        return vo;
    }

    public GoblinGoodsInfoVo getMgtGoodsInfoVo(String spuId) {
        String rk = GoblinRedisConst.BASIC_GOODS.concat(spuId);
        GoblinGoodsInfoVo vo = (GoblinGoodsInfoVo) redisUtil.get(rk);
        if (null == vo && null != (vo = goblinMongoUtils.getMgtGoodsInfoVo(spuId))) {
//            redisUtil.set(rk, vo);// TODO: 2022/1/4 zhanggb:暂不设置
        }
        return vo;
    }

    public boolean setGoodsSkuInfoVo(GoblinGoodsSkuInfoVo vo) {
        return redisUtil.set(GoblinRedisConst.BASIC_GOODS_SKU.concat(vo.getSkuId()), vo);
    }

    public void delGoodsSkuInfoVo(String skuId) {
        redisUtil.del(GoblinRedisConst.BASIC_GOODS_SKU.concat(skuId));
    }

    /**
     * 单品信息
     *
     * @param skuId 单品ID
     * @return GoblinGoodsSkuInfoVo
     */
    public GoblinGoodsSkuInfoVo getGoodsSkuInfoVo(String skuId) {
        String rk = GoblinRedisConst.BASIC_GOODS_SKU.concat(skuId);
        GoblinGoodsSkuInfoVo vo = (GoblinGoodsSkuInfoVo) redisUtil.get(rk);
        if (null == vo && null != (vo = goblinMongoUtils.getGoodsSkuInfoVo(skuId))) {
//            redisUtil.set(rk, vo);// TODO: 2022/1/4 zhanggb:暂不设置
        }
        return vo;
    }

    public GoblinGoodsSkuInfoVo getMgtGoodsSkuInfoVo(String skuId) {
        String rk = GoblinRedisConst.BASIC_GOODS_SKU.concat(skuId);
        GoblinGoodsSkuInfoVo vo = (GoblinGoodsSkuInfoVo) redisUtil.get(rk);
        if (null == vo && null != (vo = goblinMongoUtils.getMgtGoodsSkuInfoVo(skuId))) {
//            redisUtil.set(rk, vo);// TODO: 2022/1/4 zhanggb:暂不设置
        }
        return vo;
    }


    /* ----------------------------------------  ---------------------------------------- */

    /**
     * 覆盖 商铺活动vo
     *
     * @param storeMarketId
     * @param vo
     * @return
     */
    public boolean setGoblinStoreMarketVo(String storeMarketId, GoblinStoreMarketVo vo) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_MARKET.concat(storeMarketId);
        return redisUtil.set(redisKey, vo);
    }

    /**
     * 获取 商铺活动vo
     *
     * @param storeMarketId
     * @return
     */
    public GoblinStoreMarketVo getGoblinStoreMarketVo(String storeMarketId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_MARKET.concat(storeMarketId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            GoblinStoreMarketVo vo = goblinMongoUtils.getStoreMarket(storeMarketId);
            setGoblinStoreMarketVo(storeMarketId, vo);
            return vo;
        } else {
            return (GoblinStoreMarketVo) obj;
        }
    }

    /**
     * 删除 商铺活动vo
     *
     * @param storeMarketId
     * @return
     */
    public void delGoblinStoreMarketVo(String storeMarketId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_MARKET.concat(storeMarketId);
        redisUtil.del(redisKey);
    }


    /**
     * 获取 配置的商铺id
     *
     * @param marketId
     * @param storeId
     */
    public List<GoblinStoreMarketIsConfigVo> getStoreMarketIsConfig(String marketId, String storeId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_MARKET_ISCONFIG.concat(marketId).concat(":store_id:" + storeId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return new ArrayList();
        } else {
            return (List<GoblinStoreMarketIsConfigVo>) obj;
        }
    }

    public void addStoreMarketIsConfig(String marketId, String storeId, String spuId, String marketSpuId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_MARKET_ISCONFIG.concat(marketId).concat(":store_id:" + storeId);
        List<GoblinStoreMarketIsConfigVo> voList = getStoreMarketIsConfig(marketId, storeId);
        GoblinStoreMarketIsConfigVo vo = GoblinStoreMarketIsConfigVo.getNew();
        vo.setMarketSpuId(marketSpuId);
        vo.setSpuId(spuId);
        voList.add(vo);
        redisUtil.set(redisKey, voList);
    }

    public void delStoreMarketIsConfig(String marketId, String storeId, String spuId, String marketSpuId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_MARKET_ISCONFIG.concat(marketId).concat(":store_id:" + storeId);
        List<GoblinStoreMarketIsConfigVo> voList = getStoreMarketIsConfig(marketId, storeId);
        for (int i = 0; i < voList.size(); i++) {
            String itemSpuId = voList.get(i).getSpuId();
            if (spuId.equals(itemSpuId)) {
                voList.remove(i);
            }
        }
        redisUtil.set(redisKey, voList);
    }

    /**
     * 添加 活动内商品款式关联关系
     *
     * @param marketPre
     * @param marketId
     * @param vo
     */
    public void addMarketRelation(String marketPre, String marketId, GoblinMarketRelationVo vo) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_MARKET_RELATION.concat(marketPre).concat(marketId);
        List<GoblinMarketRelationVo> voList = getMarketRelation(marketPre, marketId);
        voList.add(vo);
        redisUtil.set(redisKey, voList);
    }

    /**
     * 移除 活动内商品款式关联关系
     *
     * @param marketPre
     * @param marketId
     */
    public void removeMarketRelation(String marketPre, String marketId, String spuId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_MARKET_RELATION.concat(marketPre).concat(marketId);
        List<GoblinMarketRelationVo> voList = getMarketRelation(marketPre, marketId);
        for (GoblinMarketRelationVo item : voList) {
            if (item.getSpuId().equals(spuId)) {
                voList.remove(item);
                break;
            }
        }
        redisUtil.set(redisKey, voList);
    }

    /**
     * 获取 活动内商品款式关联关系
     *
     * @param marketPre
     * @param marketId
     */
    public List<GoblinMarketRelationVo> getMarketRelation(String marketPre, String marketId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_MARKET_RELATION.concat(marketPre).concat(marketId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return new ArrayList();
        } else {
            return (List<GoblinMarketRelationVo>) obj;
        }
    }

    /**
     * 获取 当前商铺能参与的官方活动id列表
     *
     * @param storeId
     * @return
     */
    public List<String> getStoreZhengzaiRelation(String storeId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_SELF_RELATION.concat(storeId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (List<String>) obj;
        }
    }

    /**
     * 正在下单 可参加商户关系 详情
     *
     * @param selfMarketId
     * @param storeId
     */
    public GoblinMarketingZhengzaiRelationVo getZhengzaiRelation(String selfMarketId, String storeId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ZHENGZAI_RELATION.concat(selfMarketId).concat(":store_id:" + storeId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (GoblinMarketingZhengzaiRelationVo) obj;
        }
    }

    /**
     * 正在下单 可参加商户 详情
     *
     * @param selfMarketId
     */
    public GoblinSelfMarketingVo getSelfMarket(String selfMarketId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_SELF_MARKET.concat(selfMarketId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (GoblinSelfMarketingVo) obj;
        }
    }

    //获取全部正在下单的活动
    public List<GoblinSelfMarketingVo> getGoblinSelfMarketingVoList() {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ZHENGZAI_LIST;
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return goblinMongoUtils.getGoblinSelfMarketingVoList();
        } else {
            return (List<GoblinSelfMarketingVo>) obj;
        }
    }

    //获取 用户sku购买个数
    public Integer getSkuCountByUid(String uid, String skuId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_BUY_COUNT.concat(uid + ":skuId:" + skuId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (Integer) obj;
        }
    }

    // 增加 用户sku购买个数
    public int incrSkuCountByUid(String uid, String skuId, int number) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_BUY_COUNT.concat(uid + ":skuId:" + skuId);
        return (int) redisUtil.incr(redisKey, number);
    }

    // 减少 用户sku购买个数
    public int decrSkuCountByUid(String uid, String skuId, int number) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_BUY_COUNT.concat(uid + ":skuId:" + skuId);
        return (int) redisUtil.decr(redisKey, number);
    }

    //获取 sku销量
    public Integer getSkuSaleCount(String skuId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_SALE_COUNT.concat(skuId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return null;
        } else {
            return (Integer) obj;
        }
    }

    // 增加 sku销量
    public int incrSkuSaleCount(String skuId, int number) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_SALE_COUNT.concat(skuId);
        return (int) redisUtil.incr(redisKey, number);
    }

    // 减少 sku销量
    public int decrSkuSaleCount(String skuId, int number) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_SALE_COUNT.concat(skuId);
        return (int) redisUtil.decr(redisKey, number);
    }

}
