package com.liquidnet.service.kylin.dto.vo;

import com.liquidnet.service.kylin.entity.KylinPerformanceRelations;
import com.liquidnet.service.kylin.entity.KylinPerformanceStatus;
import com.liquidnet.service.kylin.entity.KylinPerformances;
import io.swagger.annotations.ApiModelProperty;
import jdk.nashorn.internal.ir.annotations.Ignore;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

@Data
public class PerformanceVo {

    @ApiModelProperty(value = "主键")
    private String performancesId;
    @ApiModelProperty(value = "演出名称")
    private String title;
    @ApiModelProperty(value = "演出开始时间")
    private String timeStart;
    @ApiModelProperty(value = "演出结束时间")
    private String timeEnd;
    @ApiModelProperty(value = "停售时间")
    private String stopSellTime;
    @ApiModelProperty(value = "价格")
    private String price;
    @ApiModelProperty(value = "开售时间")
    private String sellTime;

    @ApiModelProperty(value = "城市id")
    private String cityId;
    @ApiModelProperty(value = "场地id")
    private String fieldId;
    @ApiModelProperty(value = "场地名称")
    private String fieldName;
    @ApiModelProperty(value = "搭售id")
    private String projectId;
    @ApiModelProperty(value = "巡演id")
    private String roadShowId;

//@ApiModelProperty(value = "巡演相关")
//    private String roadShow;
    // OSS
//    @ApiModelProperty(value = "演出详情")
//    private String details;
    // OSS
//    @ApiModelProperty(value = "购票须知")
//    private String noticeImage;

    @ApiModelProperty(value = "状态")
    private int appStatus;
    @ApiModelProperty(value = "是否可买")
    private int statusSell;
    @ApiModelProperty(value = "是否关联会员")
    private int isMember;
    @ApiModelProperty(value = "是否开启缺票登记")
    private int isLackRegister;
    @ApiModelProperty(value = "是否专属")
    private int isExclusive;
    @ApiModelProperty(value = "文案")
    private String message;


    public void setPerformance(KylinPerformances performance) {
        this.performancesId = performance.getPerformancesId();
        this.title = performance.getTitle();
        this.timeStart = performance.getTimeStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.timeEnd = performance.getTimeEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public void setTimePriceVipAndLack(int isLackRegister, int isMember, int isExclusive, BigDecimal price, LocalDateTime stopSellTime, LocalDateTime sellTime) {
        this.isLackRegister = isLackRegister;
        this.isMember = isMember;
        this.isExclusive = isExclusive;
        this.price = price + "起";
        this.stopSellTime = stopSellTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.sellTime = sellTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.appStatus = 9;
        this.message = "";


    }

    public void setPerformanceStatus(KylinPerformanceStatus performanceStatus) {
        this.statusSell = performanceStatus.getStatusSell();
    }

    //TODO 巡演 搭售 场地
    public void setPerformanceRelations(KylinPerformanceRelations performanceRelations) {
        this.fieldId = "";
        this.fieldName = "";
        this.cityId = "";
        this.projectId = "";
        this.roadShowId = "";
    }
}
