package com.liquidnet.client.admin.zhengzai.merchant.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.merchant.service.IMerchantCompaniesAdminService;
import com.liquidnet.client.admin.zhengzai.merchant.service.IMerchantSponsorAppliesAdminService;
import com.liquidnet.client.admin.zhengzai.merchant.service.IMerchantSponsorsAdminService;
import com.liquidnet.client.admin.zhengzai.merchant.utils.MerchantMongoUtil;
import com.liquidnet.client.admin.zhengzai.merchant.utils.MerchantRedisUtil;
import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.merchant.dto.vo.MerchantCompaniesVo;
import com.liquidnet.service.merchant.dto.vo.MerchantSponsorAppliesVo;
import com.liquidnet.service.merchant.dto.vo.MerchantSponsorsVo;
import com.liquidnet.service.merchant.entity.MerchantCompanies;
import com.liquidnet.service.merchant.entity.MerchantSponsorApplies;
import com.liquidnet.service.merchant.entity.MerchantSponsors;
import com.liquidnet.service.merchant.mapper.MerchantSponsorAppliesMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.IntStream;

@Slf4j
@Service
public class MerchantSponsorAppliesAdminServiceImpl extends ServiceImpl<MerchantSponsorAppliesMapper, MerchantSponsorApplies> implements IMerchantSponsorAppliesAdminService {

    @Autowired
    MerchantRedisUtil merchantRedisUtil;

    @Autowired
    MerchantMongoUtil merchantMongoUtil;

    @Autowired
    IMerchantSponsorsAdminService merchantSponsorsAdminService;

    @Autowired
    IMerchantCompaniesAdminService merchantCompaniesAdminService;

    @Override
    public boolean applyApprove(String uid, String sponsorApplyId, String auditUid, String auditName) {
        List<MerchantSponsorAppliesVo> sponsorAppliesVos = merchantRedisUtil.getSponsorAppliesVosByUid(uid);
        if (CollectionUtils.isEmpty(sponsorAppliesVos)) {
            // todo error
            throw new LiquidnetServiceException();
        }
        int idx = IntStream.range(0, sponsorAppliesVos.size())
                .filter(i -> sponsorAppliesVos.get(i).getSponsorApplyId().equals(sponsorApplyId))
                .findFirst()
                .orElse(-1);
        if (idx < 0) {
            // todo error
            throw new LiquidnetServiceException();
        }
        MerchantSponsorAppliesVo sponsorAppliesVo = sponsorAppliesVos.get(idx);
        if (0 != sponsorAppliesVo.getApplyStatus()) {
            // todo error
            throw new LiquidnetServiceException();
        }

        LocalDateTime now = LocalDateTime.now();

        // 创建逻辑
        MerchantCompaniesVo companiesVo = null;
        if (!sponsorAppliesVo.getCompanyName().isEmpty()) {
            // 公司 entity mysql
            MerchantCompanies companiesEntity = new MerchantCompanies();
            companiesEntity.setCompanyId(IDGenerator.nextSnowId());
            companiesEntity.setName(sponsorAppliesVo.getCompanyName());
            companiesEntity.setLicenseCode(sponsorAppliesVo.getLicenseCode());
            companiesEntity.setLicenseImg(sponsorAppliesVo.getLicenseImg());
            companiesEntity.setLegalName(sponsorAppliesVo.getLegalName());
            companiesEntity.setLegalIdentity(sponsorAppliesVo.getLegalIdentity());
            companiesEntity.setLegalIdentityObverse(sponsorAppliesVo.getLegalIdentityObverse());
            companiesEntity.setLegalIdentityReverse(sponsorAppliesVo.getLegalIdentityReverse());
            companiesEntity.setCreatedAt(now);
            boolean success = merchantCompaniesAdminService.save(companiesEntity);
            if (!success) {
                // todo error
                throw new LiquidnetServiceException();
            }
            // 公司 vo
            companiesVo = MerchantCompaniesVo.getNew();
            companiesVo.copy(companiesEntity);
        }

        // 主办 entity mysql
        MerchantSponsors sponsorsEntity = new MerchantSponsors();
        sponsorsEntity.setSponsorId(IDGenerator.nextSnowId());
        sponsorsEntity.setIsOnline(1);
        sponsorsEntity.setUid(uid);
        sponsorsEntity.setName(sponsorAppliesVo.getName());
        sponsorsEntity.setLogo(sponsorAppliesVo.getLogo());
        sponsorsEntity.setBackground(sponsorAppliesVo.getBackground());
        sponsorsEntity.setDescription(sponsorAppliesVo.getDescription());
        sponsorsEntity.setContactName(sponsorAppliesVo.getContactName());
        sponsorsEntity.setContactIdentity(sponsorAppliesVo.getContactIdentity());
        sponsorsEntity.setContactIdentityObverse(sponsorAppliesVo.getContactIdentityObverse());
        sponsorsEntity.setContactIdentityReverse(sponsorAppliesVo.getContactIdentityReverse());
        sponsorsEntity.setContactEmail(sponsorAppliesVo.getContactEmail());
        if (null != companiesVo) {
            sponsorsEntity.setCompanyId(companiesVo.getCompanyId());
        }
        sponsorsEntity.setCreatedAt(now);
        boolean success = merchantSponsorsAdminService.save(sponsorsEntity);
        if (!success) {
            // todo error
            throw new LiquidnetServiceException();
        }
        // 主办 vo
        MerchantSponsorsVo sponsorsVo = MerchantSponsorsVo.getNew();
        sponsorsVo.copy(sponsorsEntity);
        if (null != companiesVo) {
            sponsorsVo.setCompaniesVo(companiesVo);
        }

        // 主办申请 vo
        sponsorAppliesVo.setApplyStatus(1);
        sponsorAppliesVo.setReject("");
        sponsorAppliesVo.setAuditUid(auditUid);
        sponsorAppliesVo.setAuditName(auditName);
        sponsorAppliesVo.setAuditedAt(now);
        sponsorAppliesVo.setUpdatedAt(now);
        sponsorAppliesVo.setSponsorId(sponsorsVo.getSponsorId());

        // 主办申请 mysql
        LambdaUpdateWrapper<MerchantSponsorApplies> sponsorAppliesLambdaUpdateWrapper = Wrappers.lambdaUpdate(MerchantSponsorApplies.class);
        sponsorAppliesLambdaUpdateWrapper.eq(MerchantSponsorApplies::getSponsorApplyId, sponsorAppliesVo.getSponsorApplyId());
        sponsorAppliesLambdaUpdateWrapper.set(MerchantSponsorApplies::getApplyStatus, sponsorAppliesVo.getApplyStatus());
        sponsorAppliesLambdaUpdateWrapper.set(MerchantSponsorApplies::getReject, sponsorAppliesVo.getReject());
        sponsorAppliesLambdaUpdateWrapper.set(MerchantSponsorApplies::getAuditUid, sponsorAppliesVo.getAuditUid());
        sponsorAppliesLambdaUpdateWrapper.set(MerchantSponsorApplies::getAuditName, sponsorAppliesVo.getAuditName());
        sponsorAppliesLambdaUpdateWrapper.set(MerchantSponsorApplies::getAuditedAt, sponsorAppliesVo.getAuditedAt());
        sponsorAppliesLambdaUpdateWrapper.set(MerchantSponsorApplies::getUpdatedAt, sponsorAppliesVo.getUpdatedAt());
        sponsorAppliesLambdaUpdateWrapper.set(MerchantSponsorApplies::getSponsorId, sponsorAppliesVo.getSponsorId());
        success = update(sponsorAppliesLambdaUpdateWrapper);
        if (!success) {
            // todo error
            throw new LiquidnetServiceException();
        }

        // 主办 sync mongo
        merchantMongoUtil.setSponsorsVoBySponsorId(sponsorsVo.getSponsorId(), sponsorsVo);

        // 主办 sync redis
        merchantRedisUtil.setSponsorsVoBySponsorId(sponsorsVo.getSponsorId(), sponsorsVo);

        // 主办申请 sync redis
        merchantRedisUtil.setSponsorAppliesVosByUid(uid, sponsorAppliesVos);
        
        return true;
    }

    @Override
    public boolean applyReject(String uid, String sponsorApplyId, String auditUid, String auditName, String reject) {

        return true;
    }
}
