package com.liquidnet.service.platform.controller.goblin.task;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.common.cache.redis.util.AbstractRedisUtil;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.entity.GoblinGoods;
import com.liquidnet.service.goblin.entity.GoblinStoreCoupon;
import com.liquidnet.service.platform.service.impl.goblin.PlatformGoblinGoodsService;
import com.liquidnet.service.platform.service.impl.goblin.PlatformGoblinStoreCouponService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 商城商品任务处理
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2022/1/21
 */
@Slf4j
@RestController
@RequestMapping("gstore/task")
public class PlatformGoblinStoreTaskController {
    @Autowired
    private PlatformGoblinStoreCouponService platformGoblinStoreCouponService;

    @PutMapping("market/activity")
    public ResponseDto<String> storeMarketActivityHandler() {
        int startNum = 0, stopNum = 0;

        LocalDateTime now = LocalDateTime.now();
        {// 优惠券活动
            startNum += platformGoblinStoreCouponService.activityStartProcessing(now);
            stopNum += platformGoblinStoreCouponService.activityStopProcessing(now);
        }

        return ResponseDto.success(String.format("商铺活动处理成功[开启=%s,结束=%s]", startNum, stopNum));
    }
}
