package com.liquidnet.service.platform.service.impl.goblin;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsInfoVo;
import com.liquidnet.service.platform.utils.GoblinRedisUtils;
import com.liquidnet.service.platform.utils.QueueUtils;
import com.mongodb.BasicDBObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;


/**
 * <p>
 * 订单 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-20
 */
@Service
@Slf4j
public class SpuGoodsInfoImpl {

    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoConverter mongoConverter;
    @Autowired
    private QueueUtils queueUtils;

    /**
     * 设置商品数量
     */
    public boolean setCount(){
        //mongoTemplate.findOne(Query.query(Criteria.where("spuId").is(spuId).and("delFlg").is("0").and("shelvesStatus").is("3")),
        //                GoblinGoodsInfoVo.class, GoblinGoodsInfoVo.class.getSimpleName());  shelvesStatus
        List<GoblinGoodsInfoVo> voList = mongoTemplate.find(Query.query(Criteria.where("delFlg").is("0").and("shelvesStatus").is("3")),
                GoblinGoodsInfoVo.class, GoblinGoodsInfoVo.class.getSimpleName());
        for(GoblinGoodsInfoVo goblinGoodsInfoVo:voList){
                //查询数量
            Integer counts=goblinRedisUtils.getSpuSaleCount(goblinGoodsInfoVo.getSpuId());
            HashMap<String, Object> updateMdbMap = CollectionUtil.mapStringObject();
            if(counts==null){
                updateMdbMap.put("count", 0);
//                goblinGoodsInfoVo.setCount(0);
            }else{
                updateMdbMap.put("count", counts);
//                goblinGoodsInfoVo.setCount(counts);
            }
            //修改mongodb
            BasicDBObject obj = new BasicDBObject("$set", mongoConverter.convertToMongoType(updateMdbMap));
            mongoTemplate.getCollection(GoblinGoodsInfoVo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("spuId").is(goblinGoodsInfoVo.getSpuId())).getQueryObject(),
                    obj);
        }
        log.info("执行完毕");
        goblinRedisUtils.del(GoblinRedisConst.SELECT_GOODS_SPUIDS);
        goblinRedisUtils.del(GoblinRedisConst.SELECT_GOODS_PAGE1);
        goblinRedisUtils.del(GoblinRedisConst.SELECT_GOODS_SPUIDS_ISHAVE);
        return true;
    }
}
