package com.liquidnet.common.exception.constant;

import com.liquidnet.common.exception.properties.ErrorCodeProperties;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: 错误代码
 * @class: LiquidnetServiceException
 * @Package com.liquidnet.common.exception
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/9/21 10:37
 *
 * SYS001[0001~9999] : 系统占用  SYS0010001
 * SEV001[0001~9999] : 公共业务异常
 * PAY001[0001~9999] : 支付服务
 * ACC001[0001~9999] : 账户服务
 * BAK001[0001~9999] : 三方银行服务
 * TAK001[0001~9999] : JOB任务服务
 * USR001[0001~9999] : 用户服务
 */
public enum ErrorCode implements ServiceErrorCode {

    /**
     * 服务器升级
     * <b>code: 1</b>
     */
    SYS_ERROR_SYS("-3",""),
    /**
     * 服务器更新升级
     *
     * <b>code: 1</b>
     */
    ERROR_SYS_UP("-2",""),
    REDIRECT("-1",""),
    SUCCESS("0",""),
    ERROR("1",""),
    HTTP_PARAM_ERROR("2", "Param error"),
    HTTP_SYSTEM_ERROR("50000", "System busy, please try again later"),
    ;


    ErrorCode(String code) {
        this.code = code;
    }

    ErrorCode(String code,String message) {
        this.code = code;
        this.message = message;
    }

    private String code;
    private String message;

    private static final Map<String, ErrorCode> valueMap;
    static {
        Map<String, ErrorCode> errorMap = new HashMap<String, ErrorCode>();
        for (ErrorCode errorCode : ErrorCode.values()) {
            errorMap.put(errorCode.code, errorCode);
        }
        valueMap = Collections.unmodifiableMap(errorMap);
    }
    public static ErrorCode getErrorCode(String code) {
        return valueMap.get(code);
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getVal() {
        return ErrorCodeProperties.getValue(this.code);
    }
}
