package com.liquidnet.service.kylin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.kylin.entity.KylinCamera;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * <p>
 * 人流量排队检测摄像头表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-01-11
 */

@Data
@ApiModel
public class KylinApiCameraDevicesVo implements Serializable {

    private static final long serialVersionUID = 3886640525869906268L;

    @ApiModelProperty(value = "camera_id")
    private String cameraId;

    @ApiModelProperty(value = "场地ID")
    private String fieldId;

    @ApiModelProperty(value = "地点类型 1卫生间 2。。。")
    private Integer siteType;

    @ApiModelProperty(value = "设备状态 取值：on(在线),off(离线),failed(锁定),new(未注册)")
    private String status;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;

    @ApiModelProperty(value = "修改时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    @ApiModelProperty(value = "检测到的人数")
    private Integer personNum;

    private static final KylinApiCameraDevicesVo obj = new KylinApiCameraDevicesVo();

    public static KylinApiCameraDevicesVo getNew() {
        try {
            return (KylinApiCameraDevicesVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinApiCameraDevicesVo();
        }
    }

    public KylinApiCameraDevicesVo copy(KylinCamera source) {
        KylinApiCameraDevicesVo kylinApiCameraDevicesVo = KylinApiCameraDevicesVo.getNew();
        if (null == source) return null;
        kylinApiCameraDevicesVo.setCameraId(source.getCameraId());
        kylinApiCameraDevicesVo.setFieldId(source.getFieldId());
        kylinApiCameraDevicesVo.setSiteType(source.getSiteType());
        kylinApiCameraDevicesVo.setStatus(source.getStatus());
        kylinApiCameraDevicesVo.setCreatedAt(source.getCreatedAt());
        kylinApiCameraDevicesVo.setUpdatedAt(source.getUpdatedAt());
        return kylinApiCameraDevicesVo;
    }

    /*{
        "TotalCount": 1,
            "RequestId": "D459D326-9D2D-5148-A8BA-AADEC8F2C9AF",
            "PageSize": 20,
            "PageNum": 1,
            "PageCount": 1,
            "Devices": [
        {
            "AlarmMethod": "",
                "Description": "{\"test\":\"value\"}",
                "CreatedTime": "2022-01-10T11:07:17+08:00",
                "Ip": "",
                "Port": 0,
                "Latitude": "0.0000000000",
                "Url": "",
                "Name": "人流量监控",
                "GbId": "20220101202301070001",
                "AutoStart": false,
                "Dsn": "",
                "Password": "123456",
                "Directory": {},
            "ParentId": "",
                "Status": "on",
                "Enabled": true,
                "Params": "{}",
                "Vendor": "other",
                "Longitude": "0.0000000000",
                "RegisteredTime": "2022-01-11T11:13:12+08:00",
                "GroupId": "410751715516867255-cn-beijing",
                "PosInterval": 5,
                "Type": "ipc",
                "DirectoryId": "410751715516867255-cn-beijing",
                "Username": "20220101202301070001",
                "AutoPos": true,
                "Stats": {},
            "Id": "411719749995806610-cn-beijing"
        }
  ]
    }*/

}
