package com.liquidnet.service.kylin.dto.vo.ticketSystem;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel
public class STFieldListVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 4073256621782131607L;
    @ApiModelProperty(value = "场所编码")
    private String venueCode;
    @ApiModelProperty(value = "场所名称")
    private String venueName;
    @ApiModelProperty(value = "场厅数量")
    private Integer hallNum;
    @ApiModelProperty(value = "省")
    private Integer provinceId;
    @ApiModelProperty(value = "市")
    private Integer cityId;
    @ApiModelProperty(value = "区")
    private Integer districtId;
    @ApiModelProperty(value = "详细地址")
    private String venueAddress;
    @ApiModelProperty(value = "场所类型")
    private String venueType;
    @ApiModelProperty(value = "场厅信息List")
    private List<HallListVo> hallList;

    private static final STFieldListVo obj = new STFieldListVo();

    public static STFieldListVo getNew() {
        try {
            return (STFieldListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new STFieldListVo();
    }

}
