package com.liquidnet.service.goblin.controller;

import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.codec.annotation.DecryptAndVerify;
import com.liquidnet.service.base.codec.vo.EncryptedReq;
import com.liquidnet.service.goblin.dto.vo.GoblinBraceletOrderVo;
import com.liquidnet.service.goblin.dto.vo.GoblinBraceletPayResultVo;
import com.liquidnet.service.goblin.param.GoblinBraceletOrderPayParam;
import com.liquidnet.service.goblin.param.dougong.DougongSyncCallbackparam;
import com.liquidnet.service.goblin.service.IGoblinBraceletOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.Map;

@Slf4j
@Api(tags = "商城-手环相关")
@RestController
@RequestMapping("/bracelet")
public class GoblinBraceletOrderController {

    @Autowired
    private IGoblinBraceletOrderService braceLetOrderService;

    @PostMapping("/pre")
    @ApiOperation("下单(加密)")
    @DecryptAndVerify(decryptedClass = GoblinBraceletOrderPayParam.class)
    public ResponseDto<GoblinBraceletPayResultVo> checkOrder(@RequestBody @Valid EncryptedReq<GoblinBraceletOrderPayParam> payParam) {
        return braceLetOrderService.checkOrder(payParam.getData());
    }

    @PostMapping("/fc7bce6d6c2213b866f76493f92224b8")
    @ApiOperation("下单(非加密)")
    public ResponseDto<GoblinBraceletPayResultVo> checkOrder(@RequestBody @Valid GoblinBraceletOrderPayParam payParam) {
        return braceLetOrderService.checkOrder(payParam);
    }


    @GetMapping("/checkPayment")
    @ApiOperation("查询订单状态")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单ID", example = "1"),
    })
    public ResponseDto<Integer> checkOrderResult(@RequestParam("orderId") @NotBlank(message = "订单ID不能为空") String orderId) {
        return braceLetOrderService.checkOrderResult(orderId);
    }

    @GetMapping("/order/list")
    @ApiOperation("查询订单列表")
    public ResponseDto<List<GoblinBraceletOrderVo>> getOrderList() {
        return ResponseDto.success(braceLetOrderService.getOrderList());
    }


    @PostMapping("/callback")
//    @ApiOperation("斗拱支付回调")
    public ResponseDto<Boolean> dougongCallBack(@RequestParam Map<String, Object> params) {
        log.info("dougong-callback: {}.", JsonUtils.toJson(params));
        DougongSyncCallbackparam dougongSyncCallbackparam = new DougongSyncCallbackparam();
        dougongSyncCallbackparam.setRespCode((String) params.get("resp_code"));
        dougongSyncCallbackparam.setRespDesc((String) params.get("resp_code"));
        dougongSyncCallbackparam.setSign((String) params.get("sign"));
        dougongSyncCallbackparam.setRespData((String) params.get("resp_data"));
        return braceLetOrderService.dougongCallBack(dougongSyncCallbackparam);
    }

}
