package com.liquidnet.service.platform.test;

import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.dragon.dto.DragonOrdersDto;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TestRedis
 * @Package com.liquidnet.service.adam.test
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/29 13:36
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestRedis {
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

    @Test
    public void getRedisQueueList(){

    }
    @Test
    public void pringRedisInitInfo(){
//        log.info("redisConfig.defaultDb===",redisConfig.defaultDb);
//        log.info("redisConfig.totalDbs===",redisConfig.totalDbs);
//        redisConfig.getRedisTemplateByDb(MathUtil.getIndex("1",redisConfig.defaultDb,redisConfig.totalDbs));
//
        System.out.println("getRedisKylinUtil.totalDbs==="+ redisDataSourceUtil.getRedisKylinUtil().getDbs());
        System.out.println("getRedisDragonUtil.totalDbs==="+ redisDataSourceUtil.getRedisDragonUtil().getDbs());
        System.out.println("getRedisSweetUtil.totalDbs==="+ redisDataSourceUtil.getRedisSweetUtil().getDbs());
        System.out.println("getRedisAdamUtil.totalDbs==="+ redisDataSourceUtil.getRedisAdamUtil().getDbs());
        System.out.println("getRedisCandyUtil.totalDbs==="+ redisDataSourceUtil.getRedisCandyUtil().getDbs());
    }

    @Test
    public void getRedisQueue(){
        HashMap<String, String> map = CollectionUtil.mapStringString();
        map.put("message", "oldtest20211022-001");
        log.info("getRedisKylinUtil.stream===",stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(map).withStreamKey("dragon:stream:dragon-pay")));
    }

    /**
     * 兼容测试
     */
    @Test
    public void oldPringRedisInitInfo(){
        redisDataSourceUtil.getRedisKylinUtil().set("testoldRedis","12345");
        System.out.println("getRedisKylinUtil.get==="+ redisDataSourceUtil.getRedisKylinUtil().get("testoldRedis"));
        System.out.println("getRedisDragonUtil.totalDbs==="+ redisDataSourceUtil.getRedisDragonUtil().getDbs());
    }

    /**
     * 兼容测试队列
     */
    @Test
    public void oldGetRedisQueue(){
        HashMap<String, String> map = CollectionUtil.mapStringString();
        map.put("message", "test20211022-001");
        log.info("getRedisKylinUtil.stream===",redisDataSourceUtil.getRedisKylinUtil().getStringRedisTemplate().opsForStream().add(StreamRecords.mapBacked(map).withStreamKey("dragon:stream:dragon-pay")));
        map.put("message", "test20211022-002");
        log.info("getRedisDragonUtil.stream===",redisDataSourceUtil.getRedisDragonUtil().getStringRedisTemplate().opsForStream().add(StreamRecords.mapBacked(map).withStreamKey("dragon:stream:dragon-pay")));
        map.put("message", "test20211022-003");
        log.info("getRedisSweetUtil.stream===",redisDataSourceUtil.getRedisSweetUtil().getStringRedisTemplate().opsForStream().add(StreamRecords.mapBacked(map).withStreamKey("dragon:stream:dragon-pay")));
        log.info("getRedisAdamUtil.stream===",redisDataSourceUtil.getRedisAdamUtil().getStringRedisTemplate().opsForStream().add(StreamRecords.mapBacked(map).withStreamKey("adam:stream:rk.sql.ucenter")));
        log.info("getRedisCandyUtil.stream===",redisDataSourceUtil.getRedisCandyUtil().getStringRedisTemplate().opsForStream().add(StreamRecords.mapBacked(map).withStreamKey("candy:stream:rk.coupon.back")));

//        log.info("getRedisKylinUtil.stream===",redisDataSourceUtil.getRedisKylinUtil().getStringRedisTemplate().opsForStream().size("dragon:stream:dragon-pay"));
//        log.info("getRedisDragonUtil.stream===",redisDataSourceUtil.getRedisDragonUtil().getStringRedisTemplate().opsForStream().size("dragon:stream:dragon-pay"));
//        log.info("getRedisSweetUtil.stream===",redisDataSourceUtil.getRedisSweetUtil().getStringRedisTemplate().opsForStream().size("abc"));
//        log.info("getRedisAdamUtil.stream===",redisDataSourceUtil.getRedisAdamUtil().getStringRedisTemplate().opsForStream().size("abc"));
//        log.info("getRedisCandyUtil.stream===",redisDataSourceUtil.getRedisCandyUtil().getStringRedisTemplate().opsForStream().size("abc"));
    }



    @Test
    public void getPayCodeList(){
//        List<Object> payCodeList = this.getPrefixKeyValue("dragon:pay:code:*");
//        for(Object payCode:payCodeList){
//            System.out.println("object=== "+ JsonUtils.toJson(payCode));
//        }
        //设置新的redis
        List<String> keys = getPrefixKeys("dragon:pay:code:*");
        log.info("总共迁移数据条数==="+keys.size());
        DragonOrdersDto dragonOrdersDto = DragonOrdersDto.getNew();
        for(String key:keys){
            Object obj = redisDataSourceUtil.getRedisKylinUtil().getRedisTemplateByDb(0).opsForValue().get(key);
            if(obj!=null){
                dragonOrdersDto =  (DragonOrdersDto) obj;
            }
//            redisDataSourceUtil.getRedisKylinUtil().set(key,dragonOrdersDto);
        }
//        System.out.println(redisDataSourceUtil.getRedisKylinUtil().sGet("kylin:agent:info"));
//        System.out.println(redisDataSourceUtil.getRedisKylinUtil().sHasKey("kylin:agent:info",14));

//        System.out.println(redisDataSourceUtil.getRedisKylinUtil().getRedisTemplateByDb(0).opsForValue().get("dragon:pay:code:PAY20210810193315191566757"));
//
//        List<Object> values = null;
//        // 获取所有的key
//        Set<String> keys = redisDataSourceUtil.getRedisKylinUtil().getRedisTemplateByDb(0).keys("dragon:pay:code:*");
//        if (null != keys){
//            for(String ss:keys){
//                System.out.println("ss====="+ss);
//            }
//            // 批量获取数据
//            values = redisDataSourceUtil.getRedisKylinUtil().getRedisTemplateByDb(0).opsForValue().multiGet(keys);
//        }
//        for(Object payCode:values){
//            System.out.println("object=== "+ JsonUtils.toJson(payCode));
//        }
    }

    /**
     * 获取指定前缀的值
     * @param prefix key前缀
     * @return
     */
    public List<Object> getPrefixKeyValue(String prefix) {
        List<Object> values = null;
        // 获取所有的key
        Set<String> keys = redisDataSourceUtil.getRedisKylinUtil().getRedisTemplateByDb(0).keys(prefix);
        if (null != keys){
            for(String ss:keys){
                System.out.println("ss====="+ss);
            }
            // 批量获取数据
            values = redisDataSourceUtil.getRedisKylinUtil().getRedisTemplateByDb(0).opsForValue().multiGet(keys);
        }
        return values;
    }

    /**
     * 获取指定前缀的key
     * @param prefix key前缀
     * @return
     */
    public List<String> getPrefixKeys(String prefix) {
        List<String> keysList = new ArrayList<>();
        // 获取所有的key
        Set<String> keys = redisDataSourceUtil.getRedisKylinUtil().getRedisTemplateByDb(0).keys(prefix);
        if (null != keys){
            for(String ss:keys){
                keysList.add(ss);
            }
        }
        return keysList;
    }

    private void switchRedisDbs(){

    }
}
