package com.liquidnet.service.goblin.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.service.IGoblinImportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.constraints.Null;
import java.util.List;

@Controller
@Api(tags = "订单导入")
@RequestMapping("/import")
public class GoblinImportController {   

    private String prefix = "zhengzai/kylin/performances/orderImport";

    @Autowired
    IGoblinImportService iGoblinImportService;

    /**
     * 导入对订单发货
     */
    @PostMapping("/OrderExpress")
    @ApiOperation("快递发货")
    @ResponseBody
    public ResponseDto<String> importOrderExpress(MultipartFile file) throws Exception {
//        ExcelUtil<OrderMallOrderVo> util = new ExcelUtil(OrderMallOrderVo.class);
//        List<OrderMallOrderVo> MallOrdertVoList = util.importExcel(file.getInputStream());
        return iGoblinImportService.importExpress(file);
    }
}
