package com.liquidnet.service.sweet.utils;

import com.liquidnet.service.sweet.dto.SweetManualAppletDto;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class MarkNearestUtils {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    static {
        // 如果 timeStart 是北京时间，设置时区
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT+8"));
    }

    /**
     * 1. 设置列表中距离当前时间最近的演出 isNear = 1，其余为 0
     * 2. 按timeStart 降序排列
     *
     * @param list 演出手册 DTO 列表
     */
    public static void markNearestPerformance(List<SweetManualAppletDto> list) {
        if (list == null || list.isEmpty()) {
            return;
        }

        Date now = new Date();
        SweetManualAppletDto nearest = null;
        Date nearestTime = null;

        for (SweetManualAppletDto dto : list) {
            if (dto.getTimeStart() == null || dto.getTimeStart().trim().isEmpty()) {
                dto.setIsNear(0);
                continue;
            }

            try {
                Date startTime = DATE_FORMAT.parse(dto.getTimeStart());

                // 可选：如果只考虑未来或正在进行的演出，可取消下面的注释
                 if (startTime.before(now)) continue;

                if (nearestTime == null || startTime.before(nearestTime)) {
                    nearestTime = startTime;
                    nearest = dto;
                }
            } catch (ParseException e) {
                // 解析失败，设为 0
                dto.setIsNear(0);
            }
        }
        // 先将所有 isNear 设为 0
        for (SweetManualAppletDto dto : list) {
            dto.setIsNear(0);
        }
        // 将最近的那个设为 1
        if (nearest != null) {
            nearest.setIsNear(1);
        }

        // 第二步：按 timeStart 降序排序（最新的在前）
        list.sort((a, b) -> {
            if (a.getTimeStart() == null && b.getTimeStart() == null) return 0;
            if (a.getTimeStart() == null) return 1;
            if (b.getTimeStart() == null) return -1;

            try {
                Date dateA = DATE_FORMAT.parse(a.getTimeStart());
                Date dateB = DATE_FORMAT.parse(b.getTimeStart());
                return dateB.compareTo(dateA); // 降序：b.compareTo(a)
            } catch (ParseException e) {
                // 解析失败，保持原顺序（或可抛出异常）
                return 0;
            }
        });
    }
}
