package com.liquidnet.service.sweet.controller;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.SweetManualAppletDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistList2Dto;
import com.liquidnet.service.sweet.dto.SweetManualArtistListDto;
import com.liquidnet.service.sweet.dto.SweetPerformArtistTimeListDto;
import com.liquidnet.service.sweet.entity.SweetManualNotify;
import com.liquidnet.service.sweet.entity.SweetManualShop;
import com.liquidnet.service.sweet.entity.SweetRichtext;
import com.liquidnet.service.sweet.utils.MarkNearestUtils;
import com.liquidnet.service.sweet.utils.ObjectUtil;
import com.liquidnet.service.sweet.utils.RedisArDataUtils;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import com.liquidnet.service.sweet.vo.SweetArtistsRelationVo;
import com.liquidnet.service.sweet.vo.SweetManualShopAllVo;
import com.liquidnet.service.sweet.vo.SweetPrizeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api(tags = "小程序")
@Slf4j
@RestController
@RequestMapping("/sweet-applet")
public class SweetAppletController {

    @Autowired
    private RedisDataUtils redisDataUtils;

    @Autowired
    private RedisArDataUtils arDataUtils;

    @GetMapping("timeSelect")
    @ApiOperation("场次选择")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "name", value = "名称", required = true),
    })
    public ResponseDto<List<SweetManualAppletDto>> timeSelect(@RequestParam String name) {
        List<SweetManualAppletDto> dto = redisDataUtils.getPushList();
        List<SweetManualAppletDto> vo = ObjectUtil.getSweetManualAppletDtoList();
        for (SweetManualAppletDto item : dto) {
            if (item.getTitle().contains(name)) {
                vo.add(item);
            }
        }
        MarkNearestUtils.markNearestPerformance(vo);
        return ResponseDto.success(vo);
    }

    @GetMapping("details")
    @ApiOperation("详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
    })
    public ResponseDto<SweetManualAppletDto> details(@RequestParam() String manualId) {
        return ResponseDto.success(redisDataUtils.getAppletPerformance(manualId));
    }

    @GetMapping("notify")
    @ApiOperation("通知")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
    })
    public ResponseDto<List<SweetManualNotify>> notify(@RequestParam() String manualId) {
        return ResponseDto.success(redisDataUtils.getNotifyRedisData(manualId));
    }

    @GetMapping("tags")
    @ApiOperation("标签")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
    })
    public ResponseDto<List<String>> tag(@RequestParam() String manualId) {
        return ResponseDto.success(redisDataUtils.getTagRedisData(manualId));
    }

    @GetMapping("timeList")
    @ApiOperation("时间表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "dateTime", value = "时间 全部不传", required = false),
            @ApiImplicitParam(type = "query", dataType = "String", name = "stage", value = "舞台 全部不传", required = false),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isSign", value = "是否签名(1是0否)", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "page", value = "页数", required = false),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "size", value = "数量", required = false),
            @ApiImplicitParam(type = "query", dataType = "String", name = "uid", value = "用户id", required = true),
    })
    public ResponseDto<SweetManualArtistList2Dto> timeList(@RequestParam String manualId,
                                                           @RequestParam(required = false) String dateTime,
                                                           @RequestParam(required = false) String stage,
                                                           @RequestParam Integer isSign,
                                                           @RequestParam(required = false) Integer page,
                                                           @RequestParam(required = false) Integer size,
                                                           @RequestParam String uid) {
        try {
            List<SweetManualArtistListDto> allReturnArtist = ObjectUtil.getSweetManualArtistListDtoList();
            List<SweetManualArtistListDto> returnArtist = ObjectUtil.getSweetManualArtistListDtoList();

            SweetManualArtistList2Dto data = redisDataUtils.getTimeList(manualId);
            SweetArtistsRelationVo relationData = redisDataUtils.getArtistsRelationRedisVo(uid, manualId);

            List<SweetManualArtistListDto> artistData = data.getData();

            int startPosition = 0;
            int endPosition = 0;
            if (page != null) {
                startPosition = (page - 1) * size;
                endPosition = (page) * size;
            }

            if (page == null && dateTime == null) {
                try {
                    dateTime = data.getDate().get(0);
                } catch (Exception e) {

                }
            }

            for (SweetManualArtistListDto item : artistData) {
                boolean isSave = true;
                if (isSign == 1) {
                    if (item.getSignatureStart() == null) {
                        //不保留
                        isSave = false;
                    }
                }

                if (dateTime != null) {
                    if (!item.getPerformanceStart().contains(dateTime)) {
                        //不保留
                        isSave = false;
                    }
                }

                if (stage != null) {
                    if (!item.getTitle().equalsIgnoreCase(stage)) {
                        //保留
                        isSave = false;
                    }
                }

                if (isSave) {
                    allReturnArtist.add(item);
                }
            }

            for (int i = 0; i < allReturnArtist.size(); i++) {
                SweetManualArtistListDto item = allReturnArtist.get(i);
                if (page != null && i >= startPosition && i < endPosition) {

                    item.setIsWatch(0);
                    item.setIsSign(0);

                    if (relationData.getWatchList() != null) {
                        for (String artistsId : relationData.getWatchList()) {
                            if (artistsId.equalsIgnoreCase(item.getArtistId())) {
                                item.setIsWatch(1);
                                break;
                            }
                        }
                    }
                    if (relationData.getSignList() != null) {
                        for (String artistsId : relationData.getSignList()) {
                            if (artistsId.equalsIgnoreCase(item.getArtistId())) {
                                item.setIsSign(1);
                                break;
                            }
                        }
                    }
                    if(item.getTitle().contains("&")){
                        item.setTitle(item.getTitle().split("&")[0]);
                    }
                    returnArtist.add(item);
                }
            }
            data.getStage().forEach(t->{
                if(t.getTitle().contains("&")){
                    t.setTitle(t.getTitle().split("&")[0]);
                }
            });

            data.setData(returnArtist);
            data.setTotal(allReturnArtist.size());
            return ResponseDto.success(data);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @GetMapping("performArtistTimeList")
    @ApiOperation("演出艺人时间表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "performanceId", value = "演出ID", required = true)
    })
    public ResponseDto<List<SweetPerformArtistTimeListDto>> performArtistTimeList(
            @RequestParam String performanceId
    ) {
        try {
            List<SweetPerformArtistTimeListDto> artistTimeList = arDataUtils.getArtistTimeList(performanceId);
            return ResponseDto.success(artistTimeList);
        } catch (Exception e) {
            log.error("演出艺人时间表EX [e:{}]", e);
            return ResponseDto.failure("获取失败");
        }
    }

    @GetMapping("richText")
    @ApiOperation("富文本")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "type", value = "类型 (1签售时间 2现场地图 3官方大巴 4公共交通 5自驾导航坐标 6官方支持 7观众须知 8防疫指南 9观演攻略)", required = true),
    })
    public ResponseDto<SweetRichtext> richText(@RequestParam() String manualId,
                                               @RequestParam() String type) {
        return ResponseDto.success(redisDataUtils.getRichTextRedisData(manualId, type));
    }

    @PostMapping("artistsWatch")
    @ApiOperation("艺人-想看")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "uid", value = "用户id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "artistsId", value = "艺人id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册id", required = true),
    })
    public ResponseDto<Boolean> watch(@RequestParam() String uid,
                                      @RequestParam() String artistsId,
                                      @RequestParam() String manualId) {
        if (uid.equalsIgnoreCase("0")) {
            return ResponseDto.failure();
        }
        redisDataUtils.setArtistsRelationRedisVo(uid, artistsId, manualId, "watch");
        return ResponseDto.success();
    }

    @PostMapping("artistsSign")
    @ApiOperation("艺人-签售")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "uid", value = "用户id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "artistsId", value = "艺人id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册id", required = true),
    })
    public ResponseDto<Boolean> sign(@RequestParam() String uid,
                                     @RequestParam() String artistsId,
                                     @RequestParam() String manualId) {
        if (uid.equalsIgnoreCase("0")) {
            return ResponseDto.failure();
        }
        redisDataUtils.setArtistsRelationRedisVo(uid, artistsId, manualId, "sign");
        return ResponseDto.success();
    }

    @PostMapping("manualASC")
    @ApiOperation("该手册艺人收藏数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "uid", value = "用户id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册id", required = true),
    })
    public ResponseDto<Map> manualArtistsSaveCount(@RequestParam() String uid,
                                                   @RequestParam() String manualId) {
        if (uid.equalsIgnoreCase("0")) {
            return ResponseDto.failure();
        }
        SweetArtistsRelationVo vo = redisDataUtils.getArtistsRelationRedisVo(uid, manualId);
        int signSize = 0;
        int watchSize = 0;
        if (vo.getSignList() != null) {
            signSize = vo.getSignList().size();
        }
        if (vo.getWatchList() != null) {
            watchSize = vo.getWatchList().size();
        }
        HashMap<String, Object> map = CollectionUtil.mapStringObject();
        map.put("signSize", signSize);
        map.put("watchSize", watchSize);
        return ResponseDto.success(map);
    }

    @GetMapping("artistsDetails")
    @ApiOperation("艺人-详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "artistsId", value = "艺人id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "uid", value = "用户id", required = true)
    })
    public ResponseDto<SweetManualArtistListDto> artistsDetails(@RequestParam String artistsId,
                                                                @RequestParam String manualId,
                                                                @RequestParam String uid) {
        SweetManualArtistList2Dto data = redisDataUtils.getTimeList(manualId);
        List<SweetManualArtistListDto> dataList = data.getData();
        SweetArtistsRelationVo relationData = redisDataUtils.getArtistsRelationRedisVo(uid, manualId);

        SweetManualArtistListDto vo = SweetManualArtistListDto.getNew();
        for (SweetManualArtistListDto item : dataList) {
            if (item.getArtistId().equalsIgnoreCase(artistsId)) {
                item.setIsWatch(0);
                item.setIsSign(0);
                if (relationData.getWatchList() != null) {
                    for (String artistsIds : relationData.getWatchList()) {
                        if (artistsId.equalsIgnoreCase(artistsIds)) {
                            item.setIsWatch(1);
                            break;
                        }
                    }
                }
                if (relationData.getSignList() != null) {
                    for (String artistsIds : relationData.getSignList()) {
                        if (artistsId.equalsIgnoreCase(artistsIds)) {
                            item.setIsSign(1);
                            break;
                        }
                    }
                }
                if(item.getTitle().contains("&")){
                    item.setTitle(item.getTitle().split("&")[0]);
                }
                vo = item;
                break;
            }
        }
        return ResponseDto.success(vo);
    }

    @GetMapping("manualShop")
    @ApiOperation("吃喝玩乐")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "uid", value = "用户id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "artistsId", value = "艺人id", required = true)
    })
    public ResponseDto<SweetManualShopAllVo> manualShop(@RequestParam String manualId) {
        List<SweetManualShop> shopList = redisDataUtils.getManualShopRedisData(manualId);

        List<SweetManualShop> recommend = ObjectUtil.getSweetManualShopList();
        List<SweetManualShop> eat = ObjectUtil.getSweetManualShopList();
        List<SweetManualShop> play = ObjectUtil.getSweetManualShopList();
        SweetManualShopAllVo vo = SweetManualShopAllVo.getNew();

        for (SweetManualShop item : shopList) {
            if (item.getIsRecommend().equals(1)) {
                recommend.add(item);
            }
            if (item.getType().equals(1)) {
                eat.add(item);
            }
            if (item.getType().equals(2)) {
                play.add(item);
            }
        }

        vo.setRecommend(recommend);
        vo.setEat(eat);
        vo.setPlay(play);

        return ResponseDto.success(vo);
    }

    @GetMapping("luckDraw/status")
    @ApiOperation("抽奖状态")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "mobile", value = "用户手机号", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "luckDrawNum", value = "抽奖编号", required = true),
    })
    public ResponseDto<HashMap<String, Integer>> luckDrawStatus(@RequestParam String mobile,
                                                                @RequestParam String luckDrawNum) {
        if (mobile == null || mobile.isEmpty()) {
            return ResponseDto.failure();
        }

        HashMap<String, Integer> hashMap = CollectionUtil.mapStringInteger();
        hashMap.put("count", redisDataUtils.getLuckDrawStatus(mobile, luckDrawNum));
        hashMap.put("prize", redisDataUtils.getLuckDrawResult(mobile, luckDrawNum));
        return ResponseDto.success(hashMap);
    }

    @PostMapping("luckDraw")
    @ApiOperation("抽奖")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "mobile", value = "用户手机号", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "unionId", value = "unionId", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "luckDrawNum", value = "抽奖编号", required = true),
    })
    public ResponseDto<SweetPrizeVo> luckDraw(@RequestParam String mobile,
                                              @RequestParam String unionId,
                                              @RequestParam String luckDrawNum) {
        if (mobile == null || mobile.isEmpty()) {
            return ResponseDto.failure();
        }
        SweetPrizeVo vo = redisDataUtils.changeLuckDrawStatus(mobile, unionId, luckDrawNum);
        return ResponseDto.success(vo);
    }
}
