package com.liquidnet.service.kylin.service.impl;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.param.WqTempParam;
import com.liquidnet.service.kylin.dto.vo.WqTempVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.service.IKylinConsmerService;
import com.liquidnet.service.kylin.service.IKylinTempService;
import com.liquidnet.service.kylin.utils.DataUtils;
import com.liquidnet.service.kylin.utils.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;


/**
 * <p>
 * 轮播图 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-02
 */
@Service
@Slf4j
public class KylinConsumerServiceImpl implements IKylinConsmerService {

    @Autowired
    DataUtils dataUtils;


    @Override
    public ResponseDto<Boolean> orderTransferOverTime(String orderId) {
        KylinOrderTicketVo vo = dataUtils.getOrderTicketVo(orderId);
        String uid = vo.getTransferUid();
        vo.setTransferUid("");
        vo.setTransferStatus(0);
        dataUtils.delTransferOrder(uid);
        dataUtils.setOrderTicketVo(orderId, vo);
        dataUtils.resetOrderListVo(vo.getUserId(), 2, orderId, vo);
        return null;
    }
}
