package com.liquidnet.service.kylin.service.admin;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.liquidnet.service.kylin.dao.*;
import com.liquidnet.service.kylin.dto.param.PerformanceAdminListParam;
import com.liquidnet.service.kylin.dto.param.PerformanceMemberAuditParam;
import com.liquidnet.service.kylin.dto.param.SysDamaiParam;
import com.liquidnet.service.kylin.dto.vo.admin.KylinPerformanceAgentVo;
import com.liquidnet.service.kylin.dto.vo.admin.KylinPerformanceDamaiVo;
import com.liquidnet.service.kylin.dto.vo.admin.PerformanceRefundConfigVo;
import com.liquidnet.service.kylin.dto.vo.admin.PerformanceTransferConfigVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinPerformanceMisVo;
import com.liquidnet.service.kylin.entity.KylinOrderImport;
import com.liquidnet.service.kylin.entity.KylinPerformances;

import java.util.List;

/**
 * <p>
 * 演出 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
public interface IKylinPerformancesAdminService {

    /**
     * 获取演出详情
     *
     * @param performancesId 演出id
     * @return PerformanceMisVo
     */
    KylinPerformanceMisVo performanceDetails(String performancesId);

    /**
     * 演出审核
     *
     * @param performancesId 演出id
     * @param status         审核状态 3通过 4拒绝
     * @param rejectTxt      拒绝理由 如果 status == 4 必填
     * @return boolean
     */
    boolean performanceAudit(String performancesId, int status, String rejectTxt);

    /**
     * 获取 演出列表 (全量)
     *
     * @param performanceAdminListParam 列表搜索参数
     * @return 分页 sql 数据
     */
    PageInfo<PerformanceAdminListDao> getList(PerformanceAdminListParam performanceAdminListParam);

    /**
     * 根据巡演id 查询演出列表 简易
     *
     * @param roadShowId 巡演id
     * @return 20个 sql 数据
     */
    List<PerformanceTitleDao> getListByRoadShowId(String roadShowId);

    /**
     * 根据演出状态 查询演出列表 简易
     *
     * @param status 演出状态
     * @return 20个 sql  数据
     */
    List<PerformanceTitleDao> getListByStatus(String status,String title);

    /**
     * 根据演出状态 查询演出列表 演出全量场次票
     *
     * @param status 演出状态
     * @return 20个 sql  数据
     */
    List<PerformanceSimpleAllDao> getListDetailByStatus(String status, String title);

    /**
     * 根据（演出\场次\票种）ID 查询演出、场次、票种信息
     *
     * @param scope ID所属字段
     * @param id ID值
     * @return 1条记录（包括演出名称、场次名称?、票种名称?及对于ID）
     */
    PerformanceSimpleAllDao getSimpleDetailByScopeAndId(String scope, String id);


    /**
     * 修改演出的巡演关联
     *
     * @param performancesId 演出id
     * @param roadShowId     巡演id
     * @return boolean
     */
    boolean changeRoadShowId(String performancesId, String roadShowId);

    /**
     * 根据演出id 获取推荐详情
     *
     * @param performancesId 相关参数
     * @return boolean
     */
    PerformanceRecommendDao getRecommend(String performancesId);

    /**
     * 设置 演出推荐 关联
     *
     * @param performancesId 相关参数
     * @return boolean
     */
    boolean setRecommend(String performancesId,Integer isRecommend);

    /**
     * 设置 演出推荐 关联
     *
     * @param performancesId 相关参数
     * @return boolean
     */
    Integer setIsShow(String performancesId,Integer isShow);

    /**
     * 查询 推荐演出列表
     *
     * @return 分页 sql 数据
     */
    PageInfo<PerformanceRecommendAdminDao> listRecommend();

    /**
     * 获取 演出会员信息(包含场次票)
     *
     * @param performanceId 演出id
     * @return sql 数据
     */
    PerformanceMemberAuditDao performanceMemberInfo(String performanceId);

    /**
     * 修改 演出会员信息(包含场次票)
     *
     * @param performanceMemberAuditParam 相关参数
     * @return boolean
     */
    boolean performanceMemberChange(PerformanceMemberAuditParam performanceMemberAuditParam);

    /**
     * 列表 待审核 演出会员信息
     *
     * @param title 标题
     * @return 演出名称 id
     */
    PageInfo<PerformanceTitleDao> performanceMemberList(String title, int page, int size);

    /**
     * 详情 待审核 演出会员信息
     *
     * @param performanceId 演出id
     * @param status        状态
     * @return sql 数据
     */
    PerformanceMemberAuditDao performanceMemberAuditInfo(String performanceId, Integer status);

    //审核 会员信息

    /**
     * 审核演出会员相关信息
     *
     * @param performanceId 演出id
     * @return boolean
     */
    boolean performanceMemberAudit(String performanceId, int status, String rejectTxt);

    /**
     * 列表 演出会员审核记录
     *
     * @param performanceId 演出id
     * @return 分页 vo 数据
     */
    PageInfo<PerformanceMemberAuditParam> performanceAuditHistory(String performanceId);

    /**
     * 修改 当前票种是否关联分销
     * @param ticketId 票务id
     * @param status 0 否 1 是
     * @return
     */
    boolean changeTicketAgent(String performancesId,String ticketId, Integer status);

    /**
     * 修改 演出&票种&是否同步到大麦
     * @return
     */
    boolean changeSysDamai(List<SysDamaiParam> params);

    /**
     * 获取 演出退款配置
     * @param performanceId
     * @return
     */
    PerformanceRefundConfigVo getRefundConfig(String performanceId);

    /**
     * 修改 演出退款配置
     * @return
     */
    String changeRefundConfig(String performancesId,
                               Integer isCanRefund,
                               String refundOpenTime,
                               String refundCloseTime,
                              Integer isRefundPoundage,
                              Integer isRefundVoucher,
                              Integer isRefundExpress,
                              Integer isBackPaperTicket);

    /**
     * 获取 演出转赠配置
     * @param performanceId
     * @return
     */
    PerformanceTransferConfigVo getTransferConfig(String performanceId);

    /**
     * 获取 演出转赠配置
     * @param performanceId
     * @return
     */
    List<KylinOrderImport> getOrderImport(String performanceId);

    /**
     * 修改 演出转赠配置
     * @return
     */
    String changeTransferConfig(String performancesId,
                               Integer isCanRefund,
                               String refundOpenTime,
                               String refundCloseTime);

    KylinPerformanceAgentVo getPerformanceAgent(String performancesId);

    KylinPerformanceDamaiVo getPerformanceDamai(String performancesId);

    List<PerformanceOrderStatisticalDao> getPerformanceOrderStatisticalList(String performancesId);

    List<PerformanceSponsorDao> getPerformanceSponsorList(String sponsorType);
}
