package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel(value = "AdamProScanitVo", description = "现场用户扫码信息")
@Data
public class AdamProScanitVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 5633320792752494064L;
    @ApiModelProperty(position = 11, value = "昵称")
    private String nickname;
    @ApiModelProperty(position = 12, value = "手机号")
    private String mobile;
    @ApiModelProperty(position = 13, value = "会员标记[0-普通用户｜2-过期会员｜10-老会员｜11-新会员]")
    private Integer stageMarker;
    @ApiModelProperty(position = 14, value = "用户演出标记信息List")
    private List<AdamProPerformMarkVo> performMarkVos;

    private static final AdamProScanitVo obj = new AdamProScanitVo();

    public static AdamProScanitVo getNew() {
        try {
            return (AdamProScanitVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamProScanitVo();
        }
    }
}
