package com.liquidnet.service.galaxy.dto.bo;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxySeriesNftUploadBo
 * @Package com.liquidnet.service.galaxy.dto.bo
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/28 13:25
 */
@Data
public class GalaxySeriesNftUploadBo implements Serializable,Cloneable {
    /**
     * 本地系列唯一标识id
     */
    private String skuId;
    /**
     * nft素材原始地址
     */
    private String originalNftUrl;
    /**
     * nft显示素材原始地址
     */
    private String originalDisplayUrl;
    /**
     * nft素材地址
     */
    private String nftUrl;

    /**
     * 预览图url，不超过1024个字符。(至信链浏览器展示预览图尺寸为290*290，请上传比例为1:1的图片)
     */
    private String displayUrl;

    /**
     * nft介质hash值
     */
    private String nftHashStr;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxySeriesNftUploadBo obj = new GalaxySeriesNftUploadBo();

    public static GalaxySeriesNftUploadBo getNew() {
        try {
            return (GalaxySeriesNftUploadBo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxySeriesNftUploadBo();
        }
    }
}
