package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.kylin.dao.report.PerformanceAgeDataDto;
import com.liquidnet.service.kylin.dao.report.PerformanceCityDataDto;
import com.liquidnet.service.kylin.dao.report.PerformanceProvinceDataDto;
import com.liquidnet.service.kylin.dao.report.PerformanceSexDataDto;
import com.liquidnet.service.kylin.dto.param.PerformancePartnerVo;
import com.liquidnet.service.kylin.service.IReportPerformanceService;
import com.liquidnet.service.kylin.service.admin.IKylinPerformancesAdminService;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ReportPerformanceController
 * @Package com.liquidnet.client.admin.web.controller.zhengzai.kylin
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/23 11:33
 */
@Slf4j
@Controller
@RequestMapping("/kylin/report")
public class ReportPerformanceController extends BaseController {
    private String prefix = "zhengzai/kylin/report";

    @Autowired
    private IReportPerformanceService reportPerformanceService;

    @Autowired
    private IKylinPerformancesAdminService kylinPerformancesAdminService;

    @Autowired
    private MongoTemplate mongoTemplate;

//    @RequiresPermissions("kylin:report:getPerformanceData:view")
    @GetMapping("/getPerformanceData")
    public String getPerformanceDataView(String performanceId, ModelMap mmap)
    {
        mmap.put("currentDate", LocalDate.now());
        mmap.put("performanceId", "");
        return prefix + "/performanceData";
    }

    /**
     * 查询演出列表
     */
    @Log(title = "演出报表", businessType = BusinessType.LIST)
    @RequiresPermissions("kylin:report:getPerformanceData:list")
    @PostMapping("/getPerformanceData/list")
    @ResponseBody
    public AjaxResult provincelist(@RequestParam(value = "performanceId") @Validated String performanceId, ModelMap mmap)
    {
        //获取演出详情
//        KylinPerformanceMisVo kylinPerformanceMisVo = kylinPerformancesAdminService.performanceDetails(performanceId);
        PerformancePartnerVo performanceData = mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performanceId)), PerformancePartnerVo.class, PerformancePartnerVo.class.getSimpleName());
        if(StringUtil.isNull(performanceData)||StringUtil.isNull(performanceData.getPerformancesId())){
            return AjaxResult.error("演出Id:"+performanceId+"对应演出不存在！",performanceId);
        }

        HashMap<String,Object> hashMap = new HashMap();
        log.info("ReportPerformanceController.getPerformanceData performanceId:{}",performanceId);
        //获取按省统计数据
        List<PerformanceProvinceDataDto> provinceDataList= reportPerformanceService.getProvinceDataList(performanceId);
        List<PerformanceCityDataDto> cityDataList= reportPerformanceService.getCityDataList(performanceId);
        List<PerformanceAgeDataDto> ageDataList= reportPerformanceService.getAgeDataList(performanceId);
        List<PerformanceSexDataDto> sexDataList= reportPerformanceService.getSexDataList(performanceId);

        //按年龄
//        PerformanceAgeDataDto ageDataDto = PerformanceAgeDataDto.getNew();
//        ageDataDto.setAge("19");
//        ageDataDto.setTotalNumber(34555);
//        ageDataList.add(ageDataDto);
//        ageDataDto = PerformanceAgeDataDto.getNew();
//        ageDataDto.setAge("20");
//        ageDataDto.setTotalNumber(33444);
//        ageDataList.add(ageDataDto);
//
//        //按性别
//        PerformanceSexDataDto sexDataDto = PerformanceSexDataDto.getNew();
//        sexDataDto.setSex("男");
//        sexDataDto.setTotalNumber(12345);
//        sexDataList.add(sexDataDto);
//        sexDataDto = PerformanceSexDataDto.getNew();
//        sexDataDto.setSex("女");
//        sexDataDto.setTotalNumber(99885);
//        sexDataList.add(sexDataDto);

        String perTitle = performanceData.getTitle();
        hashMap.put("currentDate", LocalDate.now());
        hashMap.put("performanceId", performanceId);
        hashMap.put("perTitle", perTitle);
        hashMap.put("provinceDataList",provinceDataList);
        hashMap.put("cityDataList",cityDataList);
        hashMap.put("ageDataList",ageDataList);
        hashMap.put("sexDataList",sexDataList);
        return AjaxResult.success(hashMap);
    }

//    /**
//     * 查询演出列表
//     */
////    @Log(title = "演出报表", businessType = BusinessType.LIST)
////    @RequiresPermissions("kylin:report:getPerformanceData:list")
//    @PostMapping("/getPerformanceData/list")
//    public String getPerformanceData(@RequestParam(value = "performanceId") @Validated String performanceId, ModelMap mmap)
//    {
//        log.info("ReportPerformanceController.getPerformanceData performanceId:{}",performanceId);
//        //获取按省统计数据
//        List<PerformanceProvinceDataDto> provinceDataList= reportPerformanceService.getProvinceDataList(performanceId);
//        //
//        List<PerformanceCityDataDto> cityDataList= reportPerformanceService.getCityDataList(performanceId);
//        List<PerformanceAgeDataDto> ageDataList= reportPerformanceService.getAgeDataList(performanceId);
//        List<PerformanceSexDataDto> sexDataDtos= reportPerformanceService.getSexDataList(performanceId);
//
//        mmap.put("currentDate", LocalDate.now());
//        mmap.put("performanceId", performanceId);
//        mmap.put("provinceDataList",provinceDataList);
//        mmap.put("cityDataList",cityDataList);
//        mmap.put("ageDataList",ageDataList);
//        mmap.put("sexDataDtos",sexDataDtos);
//        return prefix + "/performanceData";
//    }

}
