CREATE TABLE `kylin_performance_subscribe` (
                                               `mid` int(11) NOT NULL AUTO_INCREMENT,
                                               `performance_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '演出id',
                                               `ticket_times_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '场次id',
                                               `tickets_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '票种id',
                                               `user_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '用户id',
                                               `type` tinyint(2) DEFAULT '0' COMMENT '推送类型 0 开票提醒 ',
                                               `device_tokens` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '推送设备唯一标识',
                                               `push_range` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '推送设备 ios android',
                                               `push_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '推送标题',
                                               `push_time` timestamp NULL DEFAULT NULL COMMENT '推送时间',
                                               `is_push` tinyint(2) DEFAULT '0' COMMENT '是否推送 0 未推送 1推送',
                                               `created_at` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                                               `updated_at` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
                                               PRIMARY KEY (`mid`),
                                               KEY `idx_performance_id` (`performance_id`),
                                               KEY `idx_ticket_times_id` (`ticket_times_id`),
                                               KEY `idx_tickets_id` (`tickets_id`),
                                               KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='演出预约表';