package com.liquidnet.client.admin.web.controller.zhengzai.candy;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.common.utils.ShiroUtils;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyCouponRuleAdminService;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyMgtCouponAdminService;
import com.liquidnet.service.candy.dto.admin.CandyCouponRuleBuildParam;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponBuildParam;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponInfoDto;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponListParam;
import com.liquidnet.service.candy.entity.CandyCouponRule;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

@Api(tags = "券发放管理")
@Controller
@RequestMapping("candy/coupon/mgt")
public class CandyMgtCouponAdminController extends BaseController {
    private final String prefix = "zhengzai/candy/coupon/mgt";
    @Autowired
    private ICandyMgtCouponAdminService candyMgtCouponAdminService;
    @Autowired
    private ICandyCouponRuleAdminService candyCouponRuleAdminService;

    @RequiresPermissions("candy:coupon:mgt:view")
    @GetMapping()
    public String coupon(@RequestParam int couType, ModelMap mmap) {
        mmap.put("couType", couType);
        return prefix + "/coupon" + couType;
    }

    @RequiresPermissions("candy:coupon:mgt:list")
    @PostMapping("list")
    @ResponseBody
    public TableDataInfo list(CandyMgtCouponListParam listParam) {
        startPage();
        List<CandyMgtCouponInfoDto> list = candyMgtCouponAdminService.listForMgtCouponInfoDto(listParam);
        if (!CollectionUtils.isEmpty(list)) {
            switch (listParam.getCouType()) {
                case 3:
                    String[] couponIdArr = list.stream().map(CandyMgtCouponInfoDto::getCouponId).toArray(String[]::new);

                    LambdaQueryWrapper<CandyCouponRule> queryWrapper = Wrappers.lambdaQuery(CandyCouponRule.class);
                    queryWrapper.in(CandyCouponRule::getCouponId, couponIdArr);
                    queryWrapper.eq(CandyCouponRule::getState, 1);
                    queryWrapper.select(CandyCouponRule::getCruleId, CandyCouponRule::getCouponId, CandyCouponRule::getComment);
                    List<CandyCouponRule> couponRuleList = candyCouponRuleAdminService.list(queryWrapper);
                    list.stream().forEach(r->{
                        couponRuleList.forEach(cr -> {
                            if (r.getCouponId().equals(cr.getCouponId())) {
                                r.setCouponRuleScopeName(cr.getBusiName());
                            }
                        });
                    });
                    break;
            }
        }
        return getDataTable(list);
    }

    @GetMapping("add/{couType}")
    public String add(@PathVariable("couType") String couType) {
        return prefix + "/add" + couType;
    }

    @ApiOperation(value = "新建券")
    @RequiresPermissions("candy:coupon:mgt:add")
    @Log(title = "券发放管理", businessType = BusinessType.INSERT)
    @PostMapping("add")
    @ResponseBody
    public AjaxResult addSave(@RequestBody @Validated CandyMgtCouponBuildParam buildParam) {
        logger.info("operator:{},buildParam:{}", ShiroUtils.getLoginName(), buildParam);
        switch (buildParam.getCouType()) {
            case 1:// 代金券
                BigDecimal valFace = buildParam.getValFace();
                if (null == valFace || valFace.compareTo(BigDecimal.ZERO) <= 0) {
                    return AjaxResult.warn("代金券金额无效");
                }
                buildParam.setDiscount(null);
                buildParam.setValOver(null);
                buildParam.setValMinus(null);
                buildParam.setOverlay(0);
                break;
            case 2:// 满减券
                BigDecimal valOver = buildParam.getValOver();
                BigDecimal valMinus = buildParam.getValMinus();
                if (null == valOver || valOver.compareTo(BigDecimal.ZERO) <= 0
                        || null == valMinus || valMinus.compareTo(BigDecimal.ZERO) <= 0) {
                    return AjaxResult.warn("满减金额无效");
                }
                buildParam.setDiscount(null);
                buildParam.setValFace(valMinus);
                buildParam.setOverlay(0);
                break;
            case 3:// 兑换券
                buildParam.setBindType(0);
                buildParam.setDiscount(null);
                buildParam.setValFace(null);
                buildParam.setValOver(null);
                buildParam.setValMinus(null);
                buildParam.setOverlay(0);
                break;
            case 4:// 折扣券
                BigDecimal discount = buildParam.getDiscount();
                if (null == discount || discount.compareTo(BigDecimal.ZERO) <= 0) {
                    return AjaxResult.warn("折扣配置无效");
                }
                buildParam.setValFace(null);
                buildParam.setValOver(null);
                buildParam.setValMinus(null);
                break;
            case 101:
                if (null == buildParam.getOverlay()) {
                    return AjaxResult.warn("叠加限制配置无效");
                }
                buildParam.setDiscount(null);
                buildParam.setValFace(null);
                buildParam.setValOver(null);
                buildParam.setValMinus(null);
                break;
            default:
                logger.warn("Invalid operation[buildParam.couType={}]", buildParam.getCouType());
                return this.error(AjaxResult.Type.WARN, "券类型无效");
        }

        if (buildParam.getBusiType() > 0) {// 校验适用范围
            List<CandyCouponRuleBuildParam> couponRuleList = buildParam.getCouponRuleList();
            if (CollectionUtils.isEmpty(couponRuleList)) {
                return AjaxResult.warn("请指定适用范围");
            }
            CandyCouponRuleBuildParam couponRuleBuildParam = couponRuleList.get(0);
            if (couponRuleBuildParam.getUseScope() != 100 && (
                    StringUtils.isEmpty(couponRuleBuildParam.getBusiId()) || StringUtils.isEmpty(couponRuleBuildParam.getBusiName())
            )) {
                return AjaxResult.warn("请指定具体适用内容");
            }
        } else {
            buildParam.setCouponRuleList(null);
        }

        if (0 == buildParam.getBindType()) {
            buildParam.setEventType(0);
            buildParam.setEventLimit(null);
            if (null == buildParam.getRedeemValidity()) {
                return AjaxResult.warn("兑换有效期无效");
            }
        } else {
            if (buildParam.getEventType() == 2) {// 指定用户手机号
                if (StringUtils.isBlank(buildParam.getEventLimit())) {
                    return AjaxResult.warn("请指定手机号");
                }
            }
        }
        return toAjax(candyMgtCouponAdminService.saveMgtCouponForCouponBuild(buildParam));
    }
}
