package com.liquidnet.service.kylin.service.partner;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.PerformancePartnerListDao;
import com.liquidnet.service.kylin.dto.param.PerformancePartnerListParam;
import com.liquidnet.service.kylin.dto.param.PerformancePartnerVo;
import com.liquidnet.service.kylin.dto.param.PerformanceStep1Param;
import com.liquidnet.service.kylin.dto.param.PerformanceStep2Param;
import com.liquidnet.service.kylin.dto.vo.PerformanceOrderStatisticalVo;
import com.liquidnet.service.kylin.entity.KylinPerformances;

import java.util.List;

/**
 * <p>
 * 演出 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
public interface IKylinPerformancesPartnerService {


    /**
     * 演出第一步
     *
     * @param step1Param 相关参数
     * @return 演出id
     */
    String step1(PerformanceStep1Param step1Param);

    /**
     * 创建演出第一步
     *
     * @param step1Param 相关参数
     * @return 演出id
     */
    String createStep1(PerformanceStep1Param step1Param);

    /**
     * 修改演出第一步
     *
     * @param step1Param 相关参数
     * @return 演出id
     */
    String updateStep1(PerformanceStep1Param step1Param);

    /**
     * 获取演出第一步数据
     *
     * @param performancesId 演出id
     * @return 演出对象
     */
    ResponseDto<PerformancePartnerVo> getStep1(String performancesId);

    /**
     * 演出第二步
     *
     * @param step2Param 相关参数
     * @return String
     */
    ResponseDto<String> step2(PerformanceStep2Param step2Param);

    /**
     * 演出第二步创建
     *
     * @param step2Param 相关参数
     * @return String
     */
    ResponseDto<String> createStep2(PerformanceStep2Param step2Param);

    /**
     * 演出第二步修改
     *
     * @param step2Param 相关参数
     * @return String
     */
    ResponseDto<String> updateStep2(PerformanceStep2Param step2Param);

    /**
     * 获取演出第二步数据
     *
     * @param performancesId 演出id
     * @return 演出 第二步 数据
     */
    ResponseDto<PerformanceStep2Param> getStep2(String performancesId);

    /**
     * 演出上线
     *
     * @param performancesId 演出id
     * @return String
     */
    ResponseDto<String> onLinePerformance(String performancesId);

    /**
     * 演出下线
     *
     * @param performancesId 演出id
     * @return String
     */
    ResponseDto<String> outLinePerformance(String performancesId);

    /**
     * 复制演出 (只有巡演类型)
     *
     * @param performancesId 演出id
     * @return 演出id
     */
    String copyPerformance(String performancesId);

    /**
     * 演出列表
     *
     * @param performancePartnerListParam 相关参数
     * @return 分页 msql 数据
     */
    ResponseDto<PageInfo<PerformancePartnerListDao>> getList(PerformancePartnerListParam performancePartnerListParam);


    /**
     * 演出撤回
     *
     * @param performancesId 演出id
     * @return String
     */
    ResponseDto<String> withdraw(String performancesId);

    List<PerformanceOrderStatisticalVo> getPerformanceOrderStatisticalList(String performancesId);
}
