package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 活动type表
 * </p>
 *
 * @author hujiachen
 * @since 2021-12-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetActiveType implements Serializable,Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 活动名称
     */
    private String activeName;

    /**
     * type类型
     */
    private Integer type;

    /**
     * 预警个数
     */
    private Integer alarmNum;

    /**
     * 最大访问次数
     */
    private Integer maxCount;

    private LocalDateTime createdAt;

    private static final SweetActiveType obj = new SweetActiveType();
    public static SweetActiveType getNew() {
        try {
            return (SweetActiveType) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetActiveType();
        }
    }
}
