package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.vo.AdamMemberVo;
import com.liquidnet.service.adam.dto.vo.AdamUserMemberVo;
import com.liquidnet.service.adam.entity.AdamUserMember;
import com.liquidnet.service.adam.mapper.AdamMemberCodeMapper;
import com.liquidnet.service.adam.mapper.AdamUserMemberMapper;
import com.liquidnet.service.adam.service.IAdamUserMemberService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.regex.Pattern;

@Slf4j
@Service
public class AdamUserMemberServiceImpl extends ServiceImpl<AdamUserMemberMapper, AdamUserMember> implements IAdamUserMemberService {

    @Autowired
    AdamUserMemberMapper adamUserMemberMapper;
    @Autowired
    AdamMemberCodeMapper adamMemberCodeMapper;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    MongoConverter mongoConverter;
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    RedisUtil redisUtil;

    @Override
    public String getMaxMemberNo(String memberId) {
        String memberNoMaxKey = AdamRedisConst.MEMBER_MEMBER_NO_MAX_KEY.concat(memberId);
        Object maxNumber = redisUtil.get(memberNoMaxKey);

        if (null != maxNumber) {
            maxNumber = maxNumber.toString();
            String newNumber = String.valueOf(redisUtil.incr(memberNoMaxKey, 1));
            Integer newNumberInt = newNumber.length() - 1;
            String pattern = "/([\\d])\\1{" + newNumberInt + "}/";
            if (Pattern.matches(pattern, newNumber)) {// 不能是完全相同的数字
                newNumber = String.valueOf(redisUtil.incr(memberNoMaxKey, 1));
            }
            return newNumber;
        } else {
            maxNumber = adamMemberCodeMapper.getMaxMemberNo(memberId);// 1000
            if (null != maxNumber) {
                redisUtil.set(memberNoMaxKey, maxNumber);
                redisUtil.incr(memberNoMaxKey, 1);
            }
            return redisUtil.get(memberNoMaxKey).toString();
        }
    }

    @Override
    public AdamUserMemberVo getUserMemberInfo(String uid) {
        AdamUserMemberVo adamUserMemberVo = (AdamUserMemberVo) redisUtil.hget(AdamRedisConst.INFO_MEMBERS_USER_INFO.concat(uid), uid);
        if (null == adamUserMemberVo) {
            adamUserMemberVo = mongoTemplate.findOne(Query.query(Criteria.where("uid").is(uid)), AdamUserMemberVo.class, AdamUserMemberVo.class.getSimpleName());
        }
        return adamUserMemberVo;
    }

    @Override
    public boolean getOneFromRepertory(String memberId) {
        AdamMemberVo adamMemberVo = (AdamMemberVo) redisUtil.get(AdamRedisConst.INFO_MEMBERS_INFO.concat(memberId));
        if (null == adamMemberVo) {
            adamMemberVo = mongoTemplate.findOne(Query.query(Criteria.where("memberId").is(memberId)), AdamMemberVo.class, AdamMemberVo.class.getSimpleName());
        }
        if (0 == adamMemberVo.getLimitation()) {
            return true;
        }
        String repertoryKey = AdamRedisConst.INFO_MEMBERS_REPERTORY_INFO.concat(memberId);
        Object repertory = redisUtil.get(repertoryKey);
        // 判断，如果没有从redis中拿到库存数量，则把MongoDB中查出的库存插入redis
        if (null == repertory) {
            redisUtil.set(repertoryKey, adamMemberVo.getLimitation());
            repertory = adamMemberVo.getLimitation();
        }
        Long limitation = Long.parseLong(repertory.toString());
        limitation = redisUtil.decr(repertoryKey, limitation);
        // 库存大于0 正常返回，否则回滚一位库存
        if (limitation >= 0) {
            return true;
        } else {
            redisUtil.incr(repertoryKey, 1);
            return false;
        }
    }

    @Override
    public Integer getRepertoryCount(String memberId) {


        return 0;
    }
}
