/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import io.opentelemetry.javaagent.bootstrap.InternalLogger;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class PatchLogger {
    public static final String GLOBAL_LOGGER_NAME = "global";
    public static final PatchLogger global = new PatchLogger("global");
    private final InternalLogger internalLogger;
    private ResourceBundle resourceBundle;

    public static PatchLogger getLogger(String name) {
        return new PatchLogger(name);
    }

    public static PatchLogger getLogger(String name, String resourceBundleName) {
        return new PatchLogger(name);
    }

    private PatchLogger(String name) {
        this(InternalLogger.getLogger(name));
    }

    PatchLogger(InternalLogger internalLogger) {
        this.internalLogger = internalLogger;
    }

    public String getName() {
        return this.internalLogger.name();
    }

    public void severe(String msg) {
        this.internalLogger.log(InternalLogger.Level.ERROR, msg, null);
    }

    public void severe(Supplier<String> msgSupplier) {
        if (this.internalLogger.isLoggable(InternalLogger.Level.ERROR)) {
            this.internalLogger.log(InternalLogger.Level.ERROR, msgSupplier.get(), null);
        }
    }

    public void warning(String msg) {
        this.internalLogger.log(InternalLogger.Level.WARN, msg, null);
    }

    public void warning(Supplier<String> msgSupplier) {
        if (this.internalLogger.isLoggable(InternalLogger.Level.WARN)) {
            this.internalLogger.log(InternalLogger.Level.WARN, msgSupplier.get(), null);
        }
    }

    public void info(String msg) {
        this.internalLogger.log(InternalLogger.Level.INFO, msg, null);
    }

    public void info(Supplier<String> msgSupplier) {
        if (this.internalLogger.isLoggable(InternalLogger.Level.INFO)) {
            this.internalLogger.log(InternalLogger.Level.INFO, msgSupplier.get(), null);
        }
    }

    public void config(String msg) {
        this.info(msg);
    }

    public void config(Supplier<String> msgSupplier) {
        this.info(msgSupplier);
    }

    public void fine(String msg) {
        this.internalLogger.log(InternalLogger.Level.DEBUG, msg, null);
    }

    public void fine(Supplier<String> msgSupplier) {
        if (this.internalLogger.isLoggable(InternalLogger.Level.DEBUG)) {
            this.internalLogger.log(InternalLogger.Level.DEBUG, msgSupplier.get(), null);
        }
    }

    public void finer(String msg) {
        this.internalLogger.log(InternalLogger.Level.TRACE, msg, null);
    }

    public void finer(Supplier<String> msgSupplier) {
        if (this.internalLogger.isLoggable(InternalLogger.Level.TRACE)) {
            this.internalLogger.log(InternalLogger.Level.TRACE, msgSupplier.get(), null);
        }
    }

    public void finest(String msg) {
        this.finer(msg);
    }

    public void finest(Supplier<String> msgSupplier) {
        this.finer(msgSupplier);
    }

    public void log(LogRecord record) {
        InternalLogger.Level internalLevel = PatchLogger.toInternalLevel(record.getLevel());
        if (this.internalLogger.isLoggable(internalLevel)) {
            this.internalLogger.log(internalLevel, PatchLogger.getMessage(record), record.getThrown());
        }
    }

    public void log(Level level, String msg) {
        this.internalLogger.log(PatchLogger.toInternalLevel(level), msg, null);
    }

    public void log(Level level, String msg, Object param1) {
        InternalLogger.Level internalLevel = PatchLogger.toInternalLevel(level);
        if (this.internalLogger.isLoggable(internalLevel)) {
            this.internalLogger.log(internalLevel, MessageFormat.format(msg, param1), null);
        }
    }

    public void log(Level level, String msg, Object[] params) {
        InternalLogger.Level internalLevel = PatchLogger.toInternalLevel(level);
        if (this.internalLogger.isLoggable(internalLevel)) {
            this.internalLogger.log(internalLevel, MessageFormat.format(msg, params), null);
        }
    }

    public void log(Level level, String msg, Throwable thrown) {
        this.internalLogger.log(PatchLogger.toInternalLevel(level), msg, thrown);
    }

    public void log(Level level, Supplier<String> msgSupplier) {
        InternalLogger.Level internalLevel = PatchLogger.toInternalLevel(level);
        if (this.internalLogger.isLoggable(internalLevel)) {
            this.internalLogger.log(internalLevel, msgSupplier.get(), null);
        }
    }

    public void log(Level level, Throwable thrown, Supplier<String> msgSupplier) {
        InternalLogger.Level internalLevel = PatchLogger.toInternalLevel(level);
        if (this.internalLogger.isLoggable(internalLevel)) {
            this.internalLogger.log(internalLevel, msgSupplier.get(), thrown);
        }
    }

    public boolean isLoggable(Level level) {
        return this.internalLogger.isLoggable(PatchLogger.toInternalLevel(level));
    }

    public Level getLevel() {
        if (this.internalLogger.isLoggable(InternalLogger.Level.ERROR)) {
            return Level.SEVERE;
        }
        if (this.internalLogger.isLoggable(InternalLogger.Level.WARN)) {
            return Level.WARNING;
        }
        if (this.internalLogger.isLoggable(InternalLogger.Level.INFO)) {
            return Level.CONFIG;
        }
        if (this.internalLogger.isLoggable(InternalLogger.Level.DEBUG)) {
            return Level.FINE;
        }
        if (this.internalLogger.isLoggable(InternalLogger.Level.TRACE)) {
            return Level.FINEST;
        }
        return Level.OFF;
    }

    private static InternalLogger.Level toInternalLevel(Level level) {
        if (level.intValue() >= Level.SEVERE.intValue()) {
            return InternalLogger.Level.ERROR;
        }
        if (level.intValue() >= Level.WARNING.intValue()) {
            return InternalLogger.Level.WARN;
        }
        if (level.intValue() >= Level.CONFIG.intValue()) {
            return InternalLogger.Level.INFO;
        }
        if (level.intValue() >= Level.FINE.intValue()) {
            return InternalLogger.Level.DEBUG;
        }
        return InternalLogger.Level.TRACE;
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        this.log(level, msg);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        this.log(level, msg, param1);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.log(level, msg, params);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, Supplier<String> msgSupplier) {
        this.log(level, msgSupplier);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, Throwable thrown, Supplier<String> msgSupplier) {
        this.log(level, thrown, msgSupplier);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        this.log(level, msg);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        this.log(level, msg, param1);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        this.log(level, msg, params);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, ResourceBundle bundle, String msg, Object ... params) {
        this.log(level, msg, params);
    }

    public void logrb(Level level, ResourceBundle bundle, String msg, Object ... params) {
        this.log(level, msg, params);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, ResourceBundle bundle, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    public void logrb(Level level, ResourceBundle bundle, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    public void entering(String sourceClass, String sourceMethod) {
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
    }

    public void exiting(String sourceClass, String sourceMethod) {
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String getResourceBundleName() {
        return null;
    }

    public PatchLogger getParent() {
        return PatchLogger.getLogger("");
    }

    public void setParent(PatchLogger parent) {
    }

    public void setLevel(Level newLevel) {
    }

    public Handler[] getHandlers() {
        return new Handler[0];
    }

    public void addHandler(Handler handler) {
    }

    public void removeHandler(Handler handler) {
    }

    public static PatchLogger getAnonymousLogger() {
        return PatchLogger.getLogger("");
    }

    public static PatchLogger getAnonymousLogger(String resourceBundleName) {
        return PatchLogger.getLogger("");
    }

    public static PatchLogger getGlobal() {
        return global;
    }

    public void setFilter(Filter filter) {
    }

    public Filter getFilter() {
        return null;
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
    }

    public boolean getUseParentHandlers() {
        return true;
    }

    private static String getMessage(LogRecord record) {
        String msg = record.getMessage();
        Object[] params = record.getParameters();
        if (params == null) {
            return msg;
        }
        return MessageFormat.format(msg, params);
    }
}

