package com.liquidnet.service.adam.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.service.adam.entity.AdamUserBusiAcct;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamUserBizAcctVo", description = "用户业务账号信息")
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
public class AdamUserBizAcctVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 7428532456309328881L;
    @ApiModelProperty(position = 11, value = "业务码[NFT_ZX-至信数字藏品账号]")
    private String bizCode;
    @ApiModelProperty(position = 12, value = "业务账号状态[1-已开通]")
    private Integer state;
    @ApiModelProperty(position = 13, value = "业务账号ID")
    private String uuid;

    private static final AdamUserBizAcctVo obj = new AdamUserBizAcctVo();

    public static AdamUserBizAcctVo getNew() {
        try {
            return (AdamUserBizAcctVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamUserBizAcctVo();
        }
    }

    public AdamUserBizAcctVo copy(AdamUserBusiAcct source) {
        if (null == source) return this;
        this.setBizCode(source.getBusi());
        this.setUuid(source.getUuid());
        this.setState(source.getState());
        return this;
    }
}
