package com.liquidnet.commons.lang.util;

import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GlobalCoordinates;

/**
 * <p>
 * 经纬度
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-19 4:39 下午
 */
public class DistanceUtil {

    // 根据经纬度计算距离
    public static String getDistance(double longitudeFrom, double latitudeFrom, double longitudeTo, double latitudeTo) {
        GlobalCoordinates source = new GlobalCoordinates(latitudeFrom, longitudeFrom);
        GlobalCoordinates target = new GlobalCoordinates(latitudeTo, longitudeTo);
        double diffDistanceDouble = new GeodeticCalculator().calculateGeodeticCurve(Ellipsoid.Sphere, source, target).getEllipsoidalDistance();

        int diffDistanceInt = (int) diffDistanceDouble;
        String diffDistance;
        if (diffDistanceInt > 1000) {
            diffDistanceInt = diffDistanceInt / 1000;
            diffDistance = diffDistanceInt + "km";
        } else {
            diffDistance = diffDistanceInt + "m";
        }
        return diffDistance;
    }

}
