package com.liquidnet.service.goblin.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateParam;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsAnticipateVo;
import com.liquidnet.service.goblin.service.IGoblinGoodsAnticipateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 预约表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
@Slf4j
@RestController
@Api(tags = "预约相关")
@RequestMapping("/goblin/anticipate")
public class GoblinGoodsAnticipateController {

    @Autowired
    IGoblinGoodsAnticipateService goblinGoodsAnticipateService;

    @PostMapping("/list")
    @ApiOperation("获取预约列表")

    public ResponseDto<GoblinGoodsAnticipateVo> list(GoblinGoodsAnticipateParam goodsAnticipateParam) {
        return goblinGoodsAnticipateService.list(goodsAnticipateParam);
    }

    @ApiOperation("创建预约信息")
    @PostMapping("/add")
    public ResponseDto<Object> add(GoblinGoodsAnticipateAddParam goodsAnticipateAddParam){
        return goblinGoodsAnticipateService.add(goodsAnticipateAddParam);
    }

}
