package com.liquidnet.service.goblin.service.impl;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateParam;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsAnticipateVo;
import com.liquidnet.service.goblin.service.IGoblinGoodsAnticipateService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.QueueUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.LinkedList;

/**
 * <p>
 * 预约表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
@Service
public class GoblinGoodsAnticipateServiceImpl implements IGoblinGoodsAnticipateService {

    @Autowired
    GoblinMongoUtils goblinMongoUtils;

    @Autowired
    GoblinRedisUtils goblinRedisUtils;

    @Autowired
    QueueUtils queueUtils;

    @Override
    public ResponseDto<GoblinGoodsAnticipateVo> list(GoblinGoodsAnticipateParam goodsAnticipateParam) {

        PagedResult<GoblinGoodsAnticipateVo> goodsAnticipateVoPagedResult = goblinMongoUtils.getGoblinGoodsAnticipateVos(goodsAnticipateParam);


        return null;
    }

    @Override
    public ResponseDto<Object> add(GoblinGoodsAnticipateAddParam goodsAnticipateAddParam) {
        //生成的antId
        GoblinGoodsAnticipateVo goodsAnticipateVo = new GoblinGoodsAnticipateVo();
        BeanUtils.copyProperties(goodsAnticipateAddParam,goodsAnticipateVo);
        //更新mongodb
        goblinMongoUtils.setGoblinGoodsAnticipateVo(goodsAnticipateVo);

        LinkedList<String> sql = CollectionUtil.linkedListString();
        sql.add(SqlMapping.get("goblin_goods_anticipate"));
        LinkedList<Object[]> sqlData = CollectionUtil.linkedListObjectArr();
        sqlData.add(new Object[]{
                goodsAnticipateVo.getId(),
                goodsAnticipateAddParam.getName(),
                goodsAnticipateAddParam.getAboutPeople(),
                goodsAnticipateAddParam.getAboutStartDate(),
                goodsAnticipateAddParam.getAboutEndDate()
        });
        String sqlStr = SqlMapping.gets(sql,sqlData);
        //redis消息mysql新增
        queueUtils.sendMsgByRedis(
                //店铺相关
                MQConst.GoblinQueue.GOBLIN_STORE_MARKET.getKey(),
                sqlStr);
        return ResponseDto.success();
    }


}
