package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.SensitizeUtil;
import com.liquidnet.service.goblin.entity.GoblinOrderSku;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;

/**
 * <p>
 * 订单单品表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinOrderSkuVo implements Serializable, Cloneable {

    @ApiModelProperty(value = "订单sku_id")
    private String orderSkuId;
    @ApiModelProperty(value = "订单id")
    private String orderId;
    @ApiModelProperty(value = "商品id")
    private String spuId;
    @ApiModelProperty(value = "商品名称")
    private String spuName;
    @ApiModelProperty(value = "款式id")
    private String skuId;
    @ApiModelProperty(value = "数量")
    private Integer num;
    @ApiModelProperty(value = "订单状态[0-待付款(用户刚下单)|2-代发货(用户付完款 等待商城发货)|3-代收货(商城已经发货 等待用户确认收货)|4-已完成(用户已经确认收货 订单结束)|5-取消订单(用户未付款前取消订单)|6-退款通过(用户已经付款但是商城还未发货，用户发出退款申请，商城同意退款)|7-退货通过(用户已经确认收货后用户发出退货申请，商城同意所有退货申请 ，一个订单可能有多个单品)|61-6的发起状态|71-7的发起状态]")
    private int status;
    @ApiModelProperty(value = "款式原价")
    private BigDecimal skuPrice;
    @ApiModelProperty(value = "款式实付价")
    private BigDecimal skuPriceActual;
    @ApiModelProperty(value = "退款价格")
    private BigDecimal priceRefund;
    @ApiModelProperty(value = "款式名称")
    private String skuName;
    @ApiModelProperty(value = "款式编号")
    private String skuNo;
    @ApiModelProperty(value = "款式图片")
    private String skuImage;
    @ApiModelProperty(value = "款式规格")
    private String skuSpecs;
    @ApiModelProperty(value = "管理员优惠价格")
    private BigDecimal priceModify;
    @ApiModelProperty(value = "款式最终优惠价")
    private BigDecimal priceVoucher;
    @ApiModelProperty(value = "创建时间")
    private String createdAt;
    @ApiModelProperty(value = "核销时间")
    private String pushTime;

    @ApiModelProperty(value = "erp-spuNo")
    private String spuErpCode;
    @ApiModelProperty(value = "erp-skuNo")
    private String skuErpCode;
    @ApiModelProperty(value = "ERP类型[wangdian-旺店通]")
    private String erpType;
    @ApiModelProperty(value = "ERP托管[0-否|1-是]，默认0")
    private int erpHosting;
    @ApiModelProperty(value = "erp-仓库号")
    private String erpWarehouseNo;

    /**
     * ---------------------------- 以下为券类商品-代金券属性 ----------------------------
     */

    @ApiModelProperty(value = "商品类型[0-常规｜1-数字藏品｜2-券类商品]")
    private int skuType;
    @ApiModelProperty(value = "是否实名[0-否｜1-是，表示该商品需要实名关联]，这里默认0")
    private int isTrueName;
    @ApiModelProperty(value = "关联人证件类型：1-大陆身份证,2-港澳通行证,3-台胞证,4-护照,5-军官证")
    private Integer idType;
    @ApiModelProperty(value = "关联人姓名")
    private String idName;
    @ApiModelProperty(value = "关联人证件号码")
    private String idNo;

    /**
     * ---------------------------- 以上为券类商品-代金券属性 ----------------------------
     */

    public String getPushTime() {
        return pushTime == null ? "" : pushTime;
    }

    public GoblinOrderSkuVo copy(GoblinOrderSku source) {
        if (null == source) return this;
        this.setOrderSkuId(source.getOrderSkuId());
        this.setOrderId(source.getOrderId());
        this.setSpuId(source.getSpuId());
        this.setSpuName(source.getSpuName());
        this.setSkuId(source.getSkuId());
        this.setNum(source.getNum());
        this.setStatus(source.getStatus());
        this.setSkuPrice(source.getSkuPrice());
        this.setSkuPriceActual(source.getSkuPriceActual());
        this.setPriceRefund(source.getPriceRefund());
        this.setSkuName(source.getSkuName());
        this.setSkuNo(source.getSkuNo());
        this.setSkuImage(source.getSkuImage());
        this.setSkuSpecs(source.getSkuSpecs());
        this.setPriceModify(source.getPriceModify());
        this.setPriceVoucher(source.getPriceVoucher());
        this.setSpuErpCode(source.getSpuErpCode());
        this.setSkuErpCode(source.getSkuErpCode());
        this.setErpType(source.getErpType());
        this.setErpWarehouseNo(source.getErpWarehouseNo());
        this.setErpHosting(source.getErpHosting());
        this.setCreatedAt(source.getCreatedAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        return this;
    }

    public BigDecimal getPriceRefund() {
        return priceRefund == null ? BigDecimal.ZERO : priceRefund;
    }

    private static final GoblinOrderSkuVo obj = new GoblinOrderSkuVo();

    public static GoblinOrderSkuVo getNew() {
        try {
            return (GoblinOrderSkuVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinOrderSkuVo();
        }
    }

    /**
     * 脱敏处理-关联人信息
     *
     * @return AdamUserIdentityVo
     */
    public void desensitize() {
        this.setIdNo(SensitizeUtil.custom(this.getIdNo(), 3, 4));
        this.setIdName(SensitizeUtil.custom(this.getIdName(), 0, 1));
    }
}
