-- 快递模板表
drop TABLE if exists `kylin_express_module`;
CREATE TABLE `kylin_express_module`
(
    `mid`                bigint unsigned NOT NULL AUTO_INCREMENT,
    `module_id`          varchar(255)    NOT NULL DEFAULT '' COMMENT 'module_id',
    `title`              varchar(255)    NOT NULL DEFAULT '' COMMENT '快件产品名称',
    `product_code`       smallint        NOT NULL DEFAULT 0 COMMENT '产品编码',
    `aging_type`         varchar(255)    NOT NULL DEFAULT '' COMMENT '时效类型',
    `estimate_price_min` decimal(10, 2)  NOT NULL DEFAULT 0 COMMENT '快递价格（预估）',
    `estimate_price_max` decimal(10, 2)  NOT NULL DEFAULT 0 COMMENT '快递价格（预估）',
    `is_online`          tinyint         NOT NULL DEFAULT 0 COMMENT '是否上线 1未上线 2已上线',
    `created_at`         datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`         datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `idx_kylin_module_id` (`module_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '快递模板表';

alter table kylin_performance_status add is_back_paper_ticket tinyint NOT NULL DEFAULT 0 COMMENT '快递票是否需要退回 0不需要 1需要' after is_refund_express;
alter table kylin_performance_status add is_refund_express_new tinyint NOT NULL DEFAULT 0 COMMENT '用户退款快递票是否退快递费 1退回 0不退回' after is_back_paper_ticket;

alter table kylin_order_refunds add ticket_num varchar(255) NOT NULL DEFAULT '' COMMENT '纸质票号' after price_express;