package com.liquidnet.service.kylin.controller;


import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dao.KylinFreightChargeDao;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;

import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Api(tags = "前端-获取快递价格")
@RestController
@RequestMapping("getShunFengPrice")
@Slf4j
public class KylinGetShunFengPriceController {

    @Autowired
    private RedisUtil redisUtil;

    @GetMapping("getPrice")
    @ApiOperation("运费查询")
    public ResponseDto<String> getFreightCharge(String adcode, String expressType){
    /*    String substring = adcode.substring(0, 3);
        if(substring.equals("110") || substring.equals("120") || substring.equals("130")){
            if (expressType.equals("1")){
                return ResponseDto.success("23.00");
            }
        }*/
        Object  obj = redisUtil.get(KylinRedisConst.RETURN_ADDRESS_CODE + adcode + KylinRedisConst.EXPRESS_TYPE + expressType);
        if (obj != null){
            KylinFreightChargeDao k= (KylinFreightChargeDao)obj;
            //运费为0元时返23元
            if (k.getPrice().equals("0.00")){
                return ResponseDto.success("23.00");
            }
            return ResponseDto.success(k.getPrice());
        }else {
            //查询不到运费数据时返回23元
            return ResponseDto.success("23.00");
//            return ResponseDto.failure("查询失败");
        }
    }
}
