package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinFrontSeckillService;
import com.liquidnet.common.cache.redis.util.RedisGoblinUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.entity.GoblinFrontSeckill;
import com.liquidnet.service.goblin.entity.GoblinSelfMarketing;
import com.liquidnet.service.goblin.entity.GoblinStoreMarketing;
import com.liquidnet.service.goblin.mapper.GoblinFrontSeckillMapper;
import com.liquidnet.service.goblin.mapper.GoblinSelfMarketingMapper;
import com.liquidnet.service.goblin.mapper.GoblinStoreMarketingMapper;
import com.liquidnet.service.goblin.param.GoblinFrontSeckillBuildParam;
import com.mongodb.BasicDBObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 秒杀表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-29
 */
@Service
public class GoblinFrontSeckillServiceImpl extends ServiceImpl<GoblinFrontSeckillMapper, GoblinFrontSeckill> implements IGoblinFrontSeckillService {
    @Autowired
    GoblinFrontSeckillMapper goblinFrontSeckillMapper;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    GoblinStoreMarketingMapper goblinStoreMarketingMapper;
    @Autowired
    GoblinSelfMarketingMapper goblinSelfMarketingMapper;

    @Autowired
    private RedisGoblinUtil redisGoblinUtil;

    public boolean create(GoblinFrontSeckill goblinFrontSeckill){
        goblinFrontSeckill.setCreateTime(LocalDateTime.now());
        //设置bannerid
        goblinFrontSeckill.setSeckilId(GoblinRedisConst.FRONT_SECKILL+ IDGenerator.nextTimeId());
        //增加 banner
        goblinFrontSeckillMapper.insert(goblinFrontSeckill);
        return true;
    }
    /***
     * @author zhangfuxin
     * @Description: 修改
     * @date 2021/12/27 下午4:03
     */
    public boolean update(GoblinFrontSeckill goblinFrontSeckill){
        goblinFrontSeckill.setUpdateTime(LocalDateTime.now());
        //数据库修改
        goblinFrontSeckillMapper.updateById(goblinFrontSeckill);
      /*  //修改所有的展示形式
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set("activityType", goblinFrontSeckill.getActivityType());
        updateWrapper.set("show_type", goblinFrontSeckill.getShowType());

        goblinFrontSeckillMapper.update(null,updateWrapper);*/
        return true;
    }
    public GoblinFrontSeckill getOne(Long id){
        return  goblinFrontSeckillMapper.selectById(id);
    }

    public boolean delte(Long id){
        GoblinFrontSeckill goblinFrontSeckill=goblinFrontSeckillMapper.selectById(id);
        goblinFrontSeckill.setDelTag(1);
        this.update(goblinFrontSeckill);
        return true;
    }
    /**
     * @author zhangfuxin
     * @Description:分页
     * @date 2021/12/27 下午5:19
     */
    public GoblinFrontSeckillBuildParam page() {
        try {
            LambdaQueryWrapper<GoblinFrontSeckill> queryWrapper = Wrappers.lambdaQuery(GoblinFrontSeckill.class);
            queryWrapper.orderByDesc(GoblinFrontSeckill::getCreateTime);
            List<GoblinFrontSeckill> list=goblinFrontSeckillMapper.selectList(queryWrapper);
            GoblinFrontSeckillBuildParam goblinFrontSeckillBuildParam=GoblinFrontSeckillBuildParam.getNew();
            List<Map> acityList= new ArrayList<>();
            //遍历list 然后查找 官方 或者商铺
            if(list.size()>0){
                GoblinFrontSeckill goblinFrontSeckill1=list.get(0);
                BeanUtils.copyProperties(goblinFrontSeckill1,goblinFrontSeckillBuildParam);
                String selfActivityids =goblinFrontSeckill1.getSelfActivityids();
                String[] actiyids=selfActivityids.split(",");
                for(String aid:actiyids){
                    String type=aid.split("_")[0];
                    String id=aid.split("_")[1];
                    if(type.equals("g")){
                        //官方
                        GoblinSelfMarketing goblinSelfMarketing=goblinSelfMarketingMapper.selectById(id);
                        Map a=new HashMap();
                        a.put("name",goblinSelfMarketing.getName());
                        a.put("startTime",goblinSelfMarketing.getStartTime()==null?"":goblinSelfMarketing.getStartTime().format( DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                        a.put("endTime",goblinSelfMarketing.getEndTime()==null?"":goblinSelfMarketing.getEndTime().format( DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                        acityList.add(a);
                        //封装
                    }else if(type.equals("s")){
                        //商铺
                        GoblinStoreMarketing goblinStoreMarketing= goblinStoreMarketingMapper.selectById(id);
                        Map a=new HashMap();
                        a.put("name",goblinStoreMarketing.getName());
                        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                        a.put("startTime",goblinStoreMarketing.getStartTime()==null?"":goblinStoreMarketing.getStartTime().format( DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                        a.put("endTime",goblinStoreMarketing.getEndTime()==null?"":goblinStoreMarketing.getEndTime().format( DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                        acityList.add(a);
                    }
                }
                 goblinFrontSeckillBuildParam.setAcityList(acityList);
                return goblinFrontSeckillBuildParam;
            }
            //pageInfoTmp = new PageInfo(Collections.singletonList(new ArrayList().add(goblinFrontSeckillBuildParam)));
        } catch (Exception e) {
            return  null;
        }
        return null;
    }
    /**
     * @author zhangfuxin
     * @Description:上线
     * @date 2021/12/29 下午4:44
     */
    public boolean online(){
        //查询
        LambdaQueryWrapper<GoblinFrontSeckill> queryWrapper = Wrappers.lambdaQuery(GoblinFrontSeckill.class);
        queryWrapper.ne(GoblinFrontSeckill::getDelTag,1);
        queryWrapper.orderByAsc(GoblinFrontSeckill::getIndexs);
        List<GoblinFrontSeckill> list=goblinFrontSeckillMapper.selectList(queryWrapper);
        //mongodb
        for(GoblinFrontSeckill goblinFrontSeckill: list){
            GoblinFrontSeckill goblinFrontNavigation1=mongoTemplate.findOne(Query.query(Criteria.where("seckilId").is(goblinFrontSeckill.getSeckilId())), GoblinFrontSeckill.class, GoblinFrontSeckill.class.getSimpleName());
            if(null==goblinFrontNavigation1){
                mongoTemplate.save(goblinFrontSeckill,GoblinFrontSeckill.class.getSimpleName());
            }else{
                BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(goblinFrontSeckill)));
                mongoTemplate.getCollection(GoblinFrontSeckill.class.getSimpleName()).updateOne(
                        Query.query(Criteria.where("seckilId").is(goblinFrontSeckill.getSeckilId())).getQueryObject(),
                        orderObject
                );
            }
        }
        //redis  保存秒杀表信息
        redisGoblinUtil.set(GoblinRedisConst.FRONT_SECKILL,list);
        return true;
    }
}
