package com.liquidnet.service.adam.service.impl;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.adam.entity.AdamRealName;
import com.liquidnet.service.adam.service.IAdamRealNameService;
import com.liquidnet.service.adam.util.QueueUtils;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 实名信息 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-10
 */
@Slf4j
@Service
public class AdamRealNameServiceImpl implements IAdamRealNameService {
//    @Autowired
//    MongoTemplate mongoTemplate;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    QueueUtils queueUtils;

    @Override
//    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void add(AdamRealName realName) {
//        long s = System.currentTimeMillis();
//        mongoTemplate.insert(realName, AdamRealInfoVo.class.getSimpleName());
//        log.debug("#MDB耗时:{}ms", System.currentTimeMillis() - s);

        List<Object> paramList = Arrays.asList(
                realName.getRealNameId(),
                realName.getUid(),
                realName.getType(),
                realName.getName(),
                realName.getIdCard(),
                realName.getState(),
                realName.getCreatedAt()
        );
        long s = System.currentTimeMillis();
        queueUtils.sendMsgByRedis(
                MQConst.AdamQueue.SQL_UCENTER.getKey(),
                SqlMapping.get("adam_real_name.add", paramList.toArray())
        );
        log.debug("#MQ耗时:{}ms", System.currentTimeMillis() - s);
    }
}
