package com.liquidnet.service.goblin.dto.manage.vo;

import com.liquidnet.service.goblin.dto.vo.GoblinGoodsInfoVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "GoblinStoreMgtCouponSpuListVo", description = "商铺活动:优惠券关联商品SPU信息")
@Data
public class GoblinStoreMgtCouponSpuListVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -4451898306126594819L;
    @ApiModelProperty(position = 11, value = "spuId")
    private String spuId;
    @ApiModelProperty(position = 12, value = "商品名称")
    private String name;
    @ApiModelProperty(position = 13, value = "封面图片地址")
    private String coverPic;
    @ApiModelProperty(position = 14, value = "商品一级分类ID[30]")
    private String cateFid;
    @ApiModelProperty(position = 15, value = "商品二级分类ID[30]")
    private String cateSid;
    @ApiModelProperty(position = 16, value = "商品三级分类ID[30]")
    private String cateTid;
    @ApiModelProperty(position = 17, value = "价格区间MIN[20,2]")
    private BigDecimal priceGe;
    @ApiModelProperty(position = 18, value = "价格区间MAX[20,2]")
    private BigDecimal priceLe;


    private static final GoblinStoreMgtCouponSpuListVo obj = new GoblinStoreMgtCouponSpuListVo();

    public static GoblinStoreMgtCouponSpuListVo getNew() {
        try {
            return (GoblinStoreMgtCouponSpuListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreMgtCouponSpuListVo();
        }
    }

    public GoblinStoreMgtCouponSpuListVo copy(GoblinGoodsInfoVo source) {
        if (null == source) return this;
        this.setSpuId(source.getSpuId());
        this.setName(source.getName());
        this.setCoverPic(source.getCoverPic());
        this.setCateFid(source.getCateFid());
        this.setCateSid(source.getCateSid());
        this.setCateTid(source.getCateTid());
        this.setPriceGe(source.getPriceGe());
        this.setPriceLe(source.getPriceLe());
        return this;
    }
}
