package com.liquidnet.service.executor.main.handler;

import com.liquidnet.service.feign.kylin.api.FeignKylinForChimeClient;
import com.liquidnet.service.feign.kylin.task.FeignPlatformTaskClient;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * XxlJob开发示例（Bean模式）
 * <p>
 * 开发步骤：
 * 1、在Spring Bean实例中，开发Job方法，方式格式要求为 "public ReturnT<String> execute(String param)"
 * 2、为Job方法添加注解 "@XxlJob(value="自定义jobhandler名称", init = "JobHandler初始化方法", destroy = "JobHandler销毁方法")"，注解value值对应的是调度中心新建任务的JobHandler属性的值。
 * 3、执行日志：需要通过 "XxlJobLogger.log" 打印执行日志；
 */
@Component
public class KylinTaskHandler {
    @Autowired
    private FeignPlatformTaskClient feignPlatformTaskClient;

    @Autowired
    private FeignKylinForChimeClient feignKylinForChimeClient;

    @XxlJob(value = "sev-platform:checkOrderTimeHandler")
    public void checkOrderTimeHandler() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformTaskClient.checkOrderTime().getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:checkGoblinOrderTimeHandler")
    public void checkGoblinOrderTimeHandler() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformTaskClient.checkGoblinOrderTime().getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:checkPerformanceTimeHandler")
    public void checkPerformanceTimeHandler() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformTaskClient.checkPerformanceTime().getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:checkTransferOrderHandler")
    public void checkTransferOrderHandler() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformTaskClient.checkTransferOrder(Integer.parseInt(XxlJobHelper.getJobParam())).getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:performanceLine")
    public void performanceLineHandler() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignPlatformTaskClient.performanceLine().getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-platform:setNoticeIds")
    public void setNoticeIds() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignKylinForChimeClient.setNoticeIds().getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }
}
