package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistListTFCDto;
import com.liquidnet.service.sweet.entity.SweetManualArtistsTFC;
import com.liquidnet.service.sweet.mapper.SweetManualArtistsTFCMapper;
import com.liquidnet.service.sweet.service.ISweetManualArtistsTFCService;
import com.liquidnet.service.sweet.utils.RedisTFCDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 电子宣传手册艺人表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Service
public class SweetManualArtistsTFCServiceImpl extends ServiceImpl<SweetManualArtistsTFCMapper, SweetManualArtistsTFC> implements ISweetManualArtistsTFCService {
    @Autowired
    private SweetManualArtistsTFCMapper sweetManualArtistsTFCMapper;
    @Autowired
    private RedisTFCDataUtils redisDataUtils;

    @Override
    public ResponseDto<PageInfo<SweetManualArtistListTFCDto>> getList(Integer page, Integer size, String manualId) {
        PageInfo<SweetManualArtistListTFCDto> pageInfoTmp;
        try {
            PageHelper.startPage(page, size);
            HashMap<String, Object> map = CollectionUtil.mapStringObject();
            map.put("manualId", manualId);
            List<SweetManualArtistListTFCDto> voList = sweetManualArtistsTFCMapper.getManualList(map);
            pageInfoTmp = new PageInfo(voList);
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure();
        }
        return ResponseDto.success(pageInfoTmp);
    }

    @Override
    public ResponseDto<Boolean> add(String manualId, String artistId, String stageId, String performanceStart, String performanceEnd, String signatureStart, String signatureEnd) {
        try {
            SweetManualArtistsTFC sweetManualNotify = SweetManualArtistsTFC.getNew();
            sweetManualNotify.setManualRelationId(IDGenerator.nextSnowId());
            sweetManualNotify.setManualId(manualId);
            sweetManualNotify.setStageId(stageId);
            sweetManualNotify.setArtistsId(artistId);
            sweetManualNotify.setPerformanceEnd(performanceEnd != null ? DateUtil.Formatter.yyyyMMddHHmmss.parse(performanceEnd) : null);
            sweetManualNotify.setPerformanceStart(performanceStart != null ? DateUtil.Formatter.yyyyMMddHHmmss.parse(performanceStart) : null);
            sweetManualNotify.setSignatureStart(signatureStart != null ? DateUtil.Formatter.yyyyMMddHHmmss.parse(signatureStart) : null);
            sweetManualNotify.setSignatureEnd(signatureEnd != null ? DateUtil.Formatter.yyyyMMddHHmmss.parse(signatureEnd) : null);
            sweetManualNotify.setCreatedAt(LocalDateTime.now());
            sweetManualArtistsTFCMapper.insert(sweetManualNotify);

            redisDataUtils.deleteTimeListRedisData(manualId);
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<SweetManualArtistListTFCDto> details(String manualRelationId) {
        try {
            HashMap<String, Object> map = CollectionUtil.mapStringObject();
            map.put("manualRelationId", manualRelationId);
            SweetManualArtistListTFCDto dto = sweetManualArtistsTFCMapper.getManualDetails(map);
            return ResponseDto.success(dto);
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> change(String manualRelationId, String manualId, String artistId, String stageId, String performanceStart, String performanceEnd, String signatureStart, String signatureEnd) {
        try {
            SweetManualArtistsTFC sweetManualNotify = SweetManualArtistsTFC.getNew();
            sweetManualNotify.setStageId(stageId);
            sweetManualNotify.setArtistsId(artistId);
            sweetManualNotify.setPerformanceEnd(DateUtil.Formatter.yyyyMMddHHmmss.parse(performanceEnd));
            sweetManualNotify.setPerformanceStart(DateUtil.Formatter.yyyyMMddHHmmss.parse(performanceStart));
            sweetManualNotify.setSignatureStart(DateUtil.Formatter.yyyyMMddHHmmss.parse(signatureStart));
            sweetManualNotify.setSignatureEnd(DateUtil.Formatter.yyyyMMddHHmmss.parse(signatureEnd));
            sweetManualNotify.setUpdatedAt(LocalDateTime.now());
            sweetManualArtistsTFCMapper.update(sweetManualNotify, Wrappers.lambdaUpdate(SweetManualArtistsTFC.class).eq(SweetManualArtistsTFC::getManualRelationId, manualRelationId));

            redisDataUtils.deleteTimeListRedisData(manualId);
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> delete(String manualRelationId, String manualId) {
        try {
            SweetManualArtistsTFC sweetManualNotify = SweetManualArtistsTFC.getNew();
            sweetManualNotify.setManualRelationId(IDGenerator.nextSnowId());
            sweetManualNotify.setStatus(0);
            sweetManualNotify.setUpdatedAt(LocalDateTime.now());
            sweetManualArtistsTFCMapper.update(sweetManualNotify, Wrappers.lambdaUpdate(SweetManualArtistsTFC.class).eq(SweetManualArtistsTFC::getManualRelationId, manualRelationId));

            redisDataUtils.deleteTimeListRedisData(manualId);

            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }
}
