package com.liquidnet.service.sweet.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetManualSortTFC;
import com.liquidnet.service.sweet.service.ISweetManualSortTFCService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 电子宣传手册显示内容表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Api(tags = "电子手册显示tag_TFC")
@RestController
@RequestMapping("/tfc/sweet-manual-sort")
public class SweetManualSortTFCController {

    @Autowired
    private ISweetManualSortTFCService sweetManualSortTFCService;


    @PostMapping("add")
    @ApiOperation("操作 电子手册tag")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "content", value = "内容 例子(POSITION_1,POSITION_2)", required = true)
    })
    public ResponseDto<Boolean> changeStatus(@RequestParam() String manualId,
                                             @RequestParam() String content) {
        return sweetManualSortTFCService.add(manualId, content);
    }

    @GetMapping("get")
    @ApiOperation("获取 电子手册tag")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true)
    })
    public ResponseDto<SweetManualSortTFC> changeStatus(@RequestParam() String manualId) {
        return sweetManualSortTFCService.get(manualId);
    }

}
